/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Color;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode._RobotBase;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IJuniorRobot;
import robocode.robotinterfaces.peer.IJuniorRobotPeer;
import robocode.util.Utils;

public class JuniorRobot
extends _RobotBase
implements IJuniorRobot {
    public static final int black = 0;
    public static final int white = 0xFFFFFF;
    public static final int red = 0xFF0000;
    public static final int orange = 16753920;
    public static final int yellow = 0xFFFF00;
    public static final int green = 32768;
    public static final int blue = 255;
    public static final int purple = 0x800080;
    public static final int brown = 9127187;
    public static final int gray = 0x808080;
    public int fieldWidth;
    public int fieldHeight;
    public int others;
    public int energy;
    public int robotX;
    public int robotY;
    public int heading;
    public int gunHeading;
    public int gunBearing;
    public boolean gunReady;
    public int scannedDistance = -1;
    public int scannedAngle = -1;
    public int scannedBearing = -1;
    public int scannedVelocity = -99;
    public int scannedHeading = -1;
    public int scannedEnergy = -1;
    public int hitByBulletAngle = -1;
    public int hitByBulletBearing = -1;
    public int hitRobotAngle = -1;
    public int hitRobotBearing = -1;
    public int hitWallAngle = -1;
    public int hitWallBearing = -1;
    private InnerEventHandler innerEventHandler;

    public void ahead(int distance) {
        if (this.peer != null) {
            this.peer.move(distance);
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void back(int distance) {
        this.ahead(-distance);
    }

    public void bearGunTo(int angle) {
        if (this.peer != null) {
            this.peer.turnGun(Utils.normalRelativeAngle(this.peer.getBodyHeading() + Math.toRadians(angle) - this.peer.getGunHeading()));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void doNothing() {
        if (this.peer != null) {
            this.peer.execute();
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void doNothing(int turns) {
        if (turns <= 0) {
            return;
        }
        if (this.peer != null) {
            for (int i = 0; i < turns; ++i) {
                this.peer.execute();
            }
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void fire() {
        this.fire(1.0);
    }

    public void fire(double power) {
        if (this.peer != null) {
            this.getEventHandler().juniorFirePower = power;
            this.peer.execute();
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    @Override
    public final IBasicEvents getBasicEventListener() {
        return this.getEventHandler();
    }

    @Override
    public final Runnable getRobotRunnable() {
        return this.getEventHandler();
    }

    public void onHitByBullet() {
    }

    public void onHitRobot() {
    }

    public void onHitWall() {
    }

    public void onScannedRobot() {
    }

    @Override
    public void run() {
    }

    public void setColors(int bodyColor, int gunColor, int radarColor) {
        if (this.peer != null) {
            this.peer.setBodyColor(new Color(bodyColor));
            this.peer.setGunColor(new Color(gunColor));
            this.peer.setRadarColor(new Color(radarColor));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void setColors(int bodyColor, int gunColor, int radarColor, int bulletColor, int scanArcColor) {
        if (this.peer != null) {
            this.peer.setBodyColor(new Color(bodyColor));
            this.peer.setGunColor(new Color(gunColor));
            this.peer.setRadarColor(new Color(radarColor));
            this.peer.setBulletColor(new Color(bulletColor));
            this.peer.setScanColor(new Color(scanArcColor));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void turnAheadLeft(int distance, int degrees) {
        this.turnAheadRight(distance, -degrees);
    }

    public void turnAheadRight(int distance, int degrees) {
        if (this.peer != null) {
            ((IJuniorRobotPeer)this.peer).turnAndMove(distance, Math.toRadians(degrees));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void turnBackLeft(int distance, int degrees) {
        this.turnAheadRight(-distance, degrees);
    }

    public void turnBackRight(int distance, int degrees) {
        this.turnAheadRight(-distance, -degrees);
    }

    public void turnGunLeft(int degrees) {
        this.turnGunRight(-degrees);
    }

    public void turnGunRight(int degrees) {
        if (this.peer != null) {
            this.peer.turnGun(Math.toRadians(degrees));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void turnGunTo(int angle) {
        if (this.peer != null) {
            this.peer.turnGun(Utils.normalRelativeAngle(Math.toRadians(angle) - this.peer.getGunHeading()));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void turnLeft(int degrees) {
        this.turnRight(-degrees);
    }

    public void turnRight(int degrees) {
        if (this.peer != null) {
            this.peer.turnBody(Math.toRadians(degrees));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    public void turnTo(int angle) {
        if (this.peer != null) {
            this.peer.turnBody(Utils.normalRelativeAngle(Math.toRadians(angle) - this.peer.getBodyHeading()));
        } else {
            JuniorRobot.uninitializedException();
        }
    }

    private InnerEventHandler getEventHandler() {
        if (this.innerEventHandler == null) {
            this.innerEventHandler = new InnerEventHandler();
        }
        return this.innerEventHandler;
    }

    private final class InnerEventHandler
    implements IBasicEvents,
    Runnable {
        private double juniorFirePower;
        private long currentTurn;

        private InnerEventHandler() {
        }

        @Override
        public void onBulletHit(BulletHitEvent event) {
        }

        @Override
        public void onBulletHitBullet(BulletHitBulletEvent event) {
        }

        @Override
        public void onBulletMissed(BulletMissedEvent event) {
        }

        @Override
        public void onDeath(DeathEvent event) {
        }

        @Override
        public void onHitByBullet(HitByBulletEvent event) {
            double angle = JuniorRobot.this.peer.getBodyHeading() + event.getBearingRadians();
            JuniorRobot.this.hitByBulletAngle = (int)(Math.toDegrees(Utils.normalAbsoluteAngle(angle)) + 0.5);
            JuniorRobot.this.hitByBulletBearing = (int)(event.getBearing() + 0.5);
            JuniorRobot.this.onHitByBullet();
        }

        @Override
        public void onHitRobot(HitRobotEvent event) {
            double angle = JuniorRobot.this.peer.getBodyHeading() + event.getBearingRadians();
            JuniorRobot.this.hitRobotAngle = (int)(Math.toDegrees(Utils.normalAbsoluteAngle(angle)) + 0.5);
            JuniorRobot.this.hitRobotBearing = (int)(event.getBearing() + 0.5);
            JuniorRobot.this.onHitRobot();
        }

        @Override
        public void onHitWall(HitWallEvent event) {
            double angle = JuniorRobot.this.peer.getBodyHeading() + event.getBearingRadians();
            JuniorRobot.this.hitWallAngle = (int)(Math.toDegrees(Utils.normalAbsoluteAngle(angle)) + 0.5);
            JuniorRobot.this.hitWallBearing = (int)(event.getBearing() + 0.5);
            JuniorRobot.this.onHitWall();
        }

        @Override
        public void onRobotDeath(RobotDeathEvent event) {
            JuniorRobot.this.others = JuniorRobot.this.peer.getOthers();
        }

        @Override
        public void onScannedRobot(ScannedRobotEvent event) {
            JuniorRobot.this.scannedDistance = (int)(event.getDistance() + 0.5);
            JuniorRobot.this.scannedEnergy = Math.max(1, (int)(event.getEnergy() + 0.5));
            JuniorRobot.this.scannedAngle = (int)(Math.toDegrees(Utils.normalAbsoluteAngle(JuniorRobot.this.peer.getBodyHeading() + event.getBearingRadians())) + 0.5);
            JuniorRobot.this.scannedBearing = (int)(event.getBearing() + 0.5);
            JuniorRobot.this.scannedHeading = (int)(event.getHeading() + 0.5);
            JuniorRobot.this.scannedVelocity = (int)(event.getVelocity() + 0.5);
            JuniorRobot.this.onScannedRobot();
        }

        @Override
        public void onStatus(StatusEvent e) {
            RobotStatus s = e.getStatus();
            JuniorRobot.this.others = JuniorRobot.this.peer.getOthers();
            JuniorRobot.this.energy = Math.max(1, (int)(s.getEnergy() + 0.5));
            JuniorRobot.this.robotX = (int)(s.getX() + 0.5);
            JuniorRobot.this.robotY = (int)(s.getY() + 0.5);
            JuniorRobot.this.heading = (int)(s.getHeading() + 0.5);
            JuniorRobot.this.gunHeading = (int)(s.getGunHeading() + 0.5);
            JuniorRobot.this.gunBearing = (int)(Utils.normalRelativeAngle(s.getGunHeading() - s.getHeading()) + 0.5);
            JuniorRobot.this.gunReady = s.getGunHeat() <= 0.0;
            this.currentTurn = e.getTime();
            if (this.juniorFirePower > 0.0 && JuniorRobot.this.gunReady && JuniorRobot.this.peer.getGunTurnRemaining() == 0.0 && JuniorRobot.this.peer.setFire(this.juniorFirePower) != null) {
                JuniorRobot.this.gunReady = false;
                this.juniorFirePower = 0.0;
            }
            JuniorRobot.this.scannedDistance = -1;
            JuniorRobot.this.scannedAngle = -1;
            JuniorRobot.this.scannedBearing = -1;
            JuniorRobot.this.scannedVelocity = -99;
            JuniorRobot.this.scannedHeading = -1;
            JuniorRobot.this.scannedEnergy = -1;
            JuniorRobot.this.hitByBulletAngle = -1;
            JuniorRobot.this.hitByBulletBearing = -1;
            JuniorRobot.this.hitRobotAngle = -1;
            JuniorRobot.this.hitRobotBearing = -1;
            JuniorRobot.this.hitWallAngle = -1;
            JuniorRobot.this.hitWallBearing = -1;
        }

        @Override
        public void onWin(WinEvent event) {
        }

        @Override
        public void run() {
            JuniorRobot.this.fieldWidth = (int)(JuniorRobot.this.peer.getBattleFieldWidth() + 0.5);
            JuniorRobot.this.fieldHeight = (int)(JuniorRobot.this.peer.getBattleFieldHeight() + 0.5);
            while (true) {
                long lastTurn = this.currentTurn;
                JuniorRobot.this.run();
                if (lastTurn != this.currentTurn) continue;
                JuniorRobot.this.peer.rescan();
            }
        }
    }
}

