/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.security.SafeComponent;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.MouseEvent;
import robocode.robotinterfaces.IBasicRobot;
import robocode.robotinterfaces.IInteractiveEvents;
import robocode.robotinterfaces.IInteractiveRobot;

public final class MouseEnteredEvent
extends MouseEvent {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 98;

    public MouseEnteredEvent(java.awt.event.MouseEvent source) {
        super(source);
    }

    @Override
    final int getDefaultPriority() {
        return 98;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IInteractiveEvents listener;
        if (statics.isInteractiveRobot() && (listener = ((IInteractiveRobot)robot).getInteractiveEventListener()) != null) {
            listener.onMouseEntered(this.getSourceEvent());
        }
    }

    @Override
    byte getSerializationType() {
        return 49;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            return 33;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            MouseEnteredEvent obj = (MouseEnteredEvent)object;
            java.awt.event.MouseEvent src = obj.getSourceEvent();
            serializer.serialize(buffer, src.getButton());
            serializer.serialize(buffer, src.getClickCount());
            serializer.serialize(buffer, src.getX());
            serializer.serialize(buffer, src.getY());
            serializer.serialize(buffer, src.getID());
            serializer.serialize(buffer, src.getModifiersEx());
            serializer.serialize(buffer, src.getWhen());
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            int button = buffer.getInt();
            int clickCount = buffer.getInt();
            int x = buffer.getInt();
            int y = buffer.getInt();
            int id = buffer.getInt();
            int modifiersEx = buffer.getInt();
            long when = buffer.getLong();
            return new MouseEnteredEvent(new java.awt.event.MouseEvent(SafeComponent.getSafeEventComponent(), id, when, modifiersEx, x, y, clickCount, false, button));
        }
    }
}

