/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.robocode.core.ContainerBase;
import net.sf.robocode.security.IThreadManagerBase;
import robocode.exception.RobotException;

public class RobocodeFileOutputStream
extends OutputStream {
    private final FileOutputStream out;
    private final String fileName;

    public RobocodeFileOutputStream(File file) throws IOException {
        this(file.getPath());
    }

    public RobocodeFileOutputStream(FileDescriptor fdObj) {
        throw new RobotException("Creating a RobocodeFileOutputStream with a FileDescriptor is not supported.");
    }

    public RobocodeFileOutputStream(String fileName) throws IOException {
        this(fileName, false);
    }

    public RobocodeFileOutputStream(String fileName, boolean append) throws IOException {
        this.fileName = fileName;
        IThreadManagerBase threadManager = ContainerBase.getComponent(IThreadManagerBase.class);
        if (threadManager == null) {
            throw new RobotException("ThreadManager cannot be null!");
        }
        this.out = threadManager.createRobotFileStream(fileName, append);
    }

    @Override
    public final void close() throws IOException {
        this.out.close();
    }

    @Override
    public final void flush() throws IOException {
        this.out.flush();
    }

    public final String getName() {
        return this.fileName;
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public final void write(int b) throws IOException {
        this.out.write(b);
    }
}

