/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode._Robot;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicEvents3;
import robocode.robotinterfaces.IInteractiveEvents;
import robocode.robotinterfaces.IInteractiveRobot;
import robocode.robotinterfaces.IPaintEvents;
import robocode.robotinterfaces.IPaintRobot;
import robocode.robotinterfaces.peer.IStandardRobotPeer;

public class Robot
extends _Robot
implements IInteractiveRobot,
IPaintRobot,
IBasicEvents3,
IInteractiveEvents,
IPaintEvents {
    private static final int WIDTH = 36;
    private static final int HEIGHT = 36;

    @Override
    public final Runnable getRobotRunnable() {
        return this;
    }

    @Override
    public final IBasicEvents getBasicEventListener() {
        return this;
    }

    @Override
    public final IInteractiveEvents getInteractiveEventListener() {
        return this;
    }

    @Override
    public final IPaintEvents getPaintEventListener() {
        return this;
    }

    public void ahead(double distance) {
        if (this.peer != null) {
            this.peer.move(distance);
        } else {
            Robot.uninitializedException();
        }
    }

    public void back(double distance) {
        if (this.peer != null) {
            this.peer.move(-distance);
        } else {
            Robot.uninitializedException();
        }
    }

    public double getBattleFieldWidth() {
        if (this.peer != null) {
            return this.peer.getBattleFieldWidth();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public double getBattleFieldHeight() {
        if (this.peer != null) {
            return this.peer.getBattleFieldHeight();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public double getHeading() {
        if (this.peer != null) {
            double rv;
            for (rv = 180.0 * this.peer.getBodyHeading() / Math.PI; rv < 0.0; rv += 360.0) {
            }
            while (rv >= 360.0) {
                rv -= 360.0;
            }
            return rv;
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public double getHeight() {
        if (this.peer == null) {
            Robot.uninitializedException();
        }
        return 36.0;
    }

    public double getWidth() {
        if (this.peer == null) {
            Robot.uninitializedException();
        }
        return 36.0;
    }

    public String getName() {
        if (this.peer != null) {
            return this.peer.getName();
        }
        Robot.uninitializedException();
        return null;
    }

    public double getX() {
        if (this.peer != null) {
            return this.peer.getX();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public double getY() {
        if (this.peer != null) {
            return this.peer.getY();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    @Override
    public void run() {
    }

    public void turnLeft(double degrees) {
        if (this.peer != null) {
            this.peer.turnBody(-Math.toRadians(degrees));
        } else {
            Robot.uninitializedException();
        }
    }

    public void turnRight(double degrees) {
        if (this.peer != null) {
            this.peer.turnBody(Math.toRadians(degrees));
        } else {
            Robot.uninitializedException();
        }
    }

    public void doNothing() {
        if (this.peer != null) {
            this.peer.execute();
        } else {
            Robot.uninitializedException();
        }
    }

    public void fire(double power) {
        if (this.peer != null) {
            this.peer.setFire(power);
            this.peer.execute();
        } else {
            Robot.uninitializedException();
        }
    }

    public Bullet fireBullet(double power) {
        if (this.peer != null) {
            return this.peer.fire(power);
        }
        Robot.uninitializedException();
        return null;
    }

    public double getGunCoolingRate() {
        if (this.peer != null) {
            return this.peer.getGunCoolingRate();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public double getGunHeading() {
        if (this.peer != null) {
            return this.peer.getGunHeading() * 180.0 / Math.PI;
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public double getGunHeat() {
        if (this.peer != null) {
            return this.peer.getGunHeat();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public int getNumRounds() {
        if (this.peer != null) {
            return this.peer.getNumRounds();
        }
        Robot.uninitializedException();
        return 0;
    }

    public int getSentryBorderSize() {
        if (this.peer != null) {
            return this.peer.getSentryBorderSize();
        }
        Robot.uninitializedException();
        return 0;
    }

    public int getOthers() {
        if (this.peer != null) {
            return this.peer.getOthers();
        }
        Robot.uninitializedException();
        return 0;
    }

    public int getNumSentries() {
        if (this.peer != null) {
            return this.peer.getNumSentries();
        }
        Robot.uninitializedException();
        return 0;
    }

    public double getRadarHeading() {
        if (this.peer != null) {
            return this.peer.getRadarHeading() * 180.0 / Math.PI;
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public int getRoundNum() {
        if (this.peer != null) {
            return this.peer.getRoundNum();
        }
        Robot.uninitializedException();
        return 0;
    }

    public long getTime() {
        if (this.peer != null) {
            return this.peer.getTime();
        }
        Robot.uninitializedException();
        return 0L;
    }

    public double getVelocity() {
        if (this.peer != null) {
            return this.peer.getVelocity();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent event) {
    }

    @Override
    public void onBulletMissed(BulletMissedEvent event) {
    }

    @Override
    public void onDeath(DeathEvent event) {
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
    }

    @Override
    public void onHitWall(HitWallEvent event) {
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
    }

    @Override
    public void onWin(WinEvent event) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
    }

    @Override
    public void onBattleEnded(BattleEndedEvent event) {
    }

    public void scan() {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).rescan();
        } else {
            Robot.uninitializedException();
        }
    }

    public void setAdjustGunForRobotTurn(boolean independent) {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).setAdjustGunForBodyTurn(independent);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setAdjustRadarForRobotTurn(boolean independent) {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).setAdjustRadarForBodyTurn(independent);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setAdjustRadarForGunTurn(boolean independent) {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).setAdjustRadarForGunTurn(independent);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setColors(Color bodyColor, Color gunColor, Color radarColor) {
        if (this.peer != null) {
            this.peer.setBodyColor(bodyColor);
            this.peer.setGunColor(gunColor);
            this.peer.setRadarColor(radarColor);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setColors(Color bodyColor, Color gunColor, Color radarColor, Color bulletColor, Color scanArcColor) {
        if (this.peer != null) {
            this.peer.setBodyColor(bodyColor);
            this.peer.setGunColor(gunColor);
            this.peer.setRadarColor(radarColor);
            this.peer.setBulletColor(bulletColor);
            this.peer.setScanColor(scanArcColor);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setAllColors(Color color) {
        if (this.peer != null) {
            this.peer.setBodyColor(color);
            this.peer.setGunColor(color);
            this.peer.setRadarColor(color);
            this.peer.setBulletColor(color);
            this.peer.setScanColor(color);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setBodyColor(Color color) {
        if (this.peer != null) {
            this.peer.setBodyColor(color);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setGunColor(Color color) {
        if (this.peer != null) {
            this.peer.setGunColor(color);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setRadarColor(Color color) {
        if (this.peer != null) {
            this.peer.setRadarColor(color);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setBulletColor(Color color) {
        if (this.peer != null) {
            this.peer.setBulletColor(color);
        } else {
            Robot.uninitializedException();
        }
    }

    public void setScanColor(Color color) {
        if (this.peer != null) {
            this.peer.setScanColor(color);
        } else {
            Robot.uninitializedException();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean overwrite) {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).stop(overwrite);
        } else {
            Robot.uninitializedException();
        }
    }

    public void resume() {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).resume();
        } else {
            Robot.uninitializedException();
        }
    }

    public void turnGunLeft(double degrees) {
        if (this.peer != null) {
            this.peer.turnGun(-Math.toRadians(degrees));
        } else {
            Robot.uninitializedException();
        }
    }

    public void turnGunRight(double degrees) {
        if (this.peer != null) {
            this.peer.turnGun(Math.toRadians(degrees));
        } else {
            Robot.uninitializedException();
        }
    }

    public void turnRadarLeft(double degrees) {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).turnRadar(-Math.toRadians(degrees));
        } else {
            Robot.uninitializedException();
        }
    }

    public void turnRadarRight(double degrees) {
        if (this.peer != null) {
            ((IStandardRobotPeer)this.peer).turnRadar(Math.toRadians(degrees));
        } else {
            Robot.uninitializedException();
        }
    }

    public double getEnergy() {
        if (this.peer != null) {
            return this.peer.getEnergy();
        }
        Robot.uninitializedException();
        return 0.0;
    }

    public Graphics2D getGraphics() {
        if (this.peer != null) {
            return this.peer.getGraphics();
        }
        Robot.uninitializedException();
        return null;
    }

    public void setDebugProperty(String key, String value) {
        if (this.peer != null) {
            this.peer.setDebugProperty(key, value);
            return;
        }
        Robot.uninitializedException();
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    @Override
    public void onKeyPressed(KeyEvent e) {
    }

    @Override
    public void onKeyReleased(KeyEvent e) {
    }

    @Override
    public void onKeyTyped(KeyEvent e) {
    }

    @Override
    public void onMouseClicked(MouseEvent e) {
    }

    @Override
    public void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void onMouseExited(MouseEvent e) {
    }

    @Override
    public void onMousePressed(MouseEvent e) {
    }

    @Override
    public void onMouseReleased(MouseEvent e) {
    }

    @Override
    public void onMouseMoved(MouseEvent e) {
    }

    @Override
    public void onMouseDragged(MouseEvent e) {
    }

    @Override
    public void onMouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void onStatus(StatusEvent e) {
    }
}

