/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicRobot;

public final class RobotDeathEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 70;
    private final String robotName;

    public RobotDeathEvent(String robotName) {
        this.robotName = robotName;
    }

    public String getName() {
        return this.robotName;
    }

    @Deprecated
    public String getRobotName() {
        return this.robotName;
    }

    @Override
    final int getDefaultPriority() {
        return 70;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener = robot.getBasicEventListener();
        if (listener != null) {
            listener.onRobotDeath(this);
        }
    }

    @Override
    byte getSerializationType() {
        return 39;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            RobotDeathEvent obj = (RobotDeathEvent)object;
            return 1 + serializer.sizeOf(obj.robotName);
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            RobotDeathEvent obj = (RobotDeathEvent)object;
            serializer.serialize(buffer, obj.robotName);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            String name = serializer.deserializeString(buffer);
            return new RobotDeathEvent(name);
        }
    }
}

