/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.robocode.security.IHiddenStatusHelper;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;

public final class RobotStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double energy;
    private final double x;
    private final double y;
    private final double bodyHeading;
    private final double gunHeading;
    private final double radarHeading;
    private final double velocity;
    private final double bodyTurnRemaining;
    private final double radarTurnRemaining;
    private final double gunTurnRemaining;
    private final double distanceRemaining;
    private final double gunHeat;
    private final int others;
    private final int numSentries;
    private final int roundNum;
    private final int numRounds;
    private final long time;

    public double getEnergy() {
        return this.energy;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getHeadingRadians() {
        return this.bodyHeading;
    }

    public double getHeading() {
        return Math.toDegrees(this.bodyHeading);
    }

    public double getGunHeadingRadians() {
        return this.gunHeading;
    }

    public double getGunHeading() {
        return Math.toDegrees(this.gunHeading);
    }

    public double getRadarHeadingRadians() {
        return this.radarHeading;
    }

    public double getRadarHeading() {
        return Math.toDegrees(this.radarHeading);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getTurnRemainingRadians() {
        return this.bodyTurnRemaining;
    }

    public double getTurnRemaining() {
        return Math.toDegrees(this.bodyTurnRemaining);
    }

    public double getRadarTurnRemainingRadians() {
        return this.radarTurnRemaining;
    }

    public double getRadarTurnRemaining() {
        return Math.toDegrees(this.radarTurnRemaining);
    }

    public double getGunTurnRemainingRadians() {
        return this.gunTurnRemaining;
    }

    public double getGunTurnRemaining() {
        return Math.toDegrees(this.gunTurnRemaining);
    }

    public double getDistanceRemaining() {
        return this.distanceRemaining;
    }

    public double getGunHeat() {
        return this.gunHeat;
    }

    public int getOthers() {
        return this.others;
    }

    public int getNumSentries() {
        return this.numSentries;
    }

    public int getNumRounds() {
        return this.numRounds;
    }

    public int getRoundNum() {
        return this.roundNum;
    }

    public long getTime() {
        return this.time;
    }

    private RobotStatus(double energy, double x, double y, double bodyHeading, double gunHeading, double radarHeading, double velocity, double bodyTurnRemaining, double radarTurnRemaining, double gunTurnRemaining, double distanceRemaining, double gunHeat, int others, int numSentries, int roundNum, int numRounds, long time) {
        this.energy = energy;
        this.x = x;
        this.y = y;
        this.bodyHeading = bodyHeading;
        this.gunHeading = gunHeading;
        this.radarHeading = radarHeading;
        this.bodyTurnRemaining = bodyTurnRemaining;
        this.velocity = velocity;
        this.radarTurnRemaining = radarTurnRemaining;
        this.gunTurnRemaining = gunTurnRemaining;
        this.distanceRemaining = distanceRemaining;
        this.gunHeat = gunHeat;
        this.others = others;
        this.numSentries = numSentries;
        this.roundNum = roundNum;
        this.numRounds = numRounds;
        this.time = time;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper,
    IHiddenStatusHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            return 121;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            RobotStatus obj = (RobotStatus)object;
            serializer.serialize(buffer, obj.energy);
            serializer.serialize(buffer, obj.x);
            serializer.serialize(buffer, obj.y);
            serializer.serialize(buffer, obj.bodyHeading);
            serializer.serialize(buffer, obj.gunHeading);
            serializer.serialize(buffer, obj.radarHeading);
            serializer.serialize(buffer, obj.velocity);
            serializer.serialize(buffer, obj.bodyTurnRemaining);
            serializer.serialize(buffer, obj.radarTurnRemaining);
            serializer.serialize(buffer, obj.gunTurnRemaining);
            serializer.serialize(buffer, obj.distanceRemaining);
            serializer.serialize(buffer, obj.gunHeat);
            serializer.serialize(buffer, obj.others);
            serializer.serialize(buffer, obj.numSentries);
            serializer.serialize(buffer, obj.roundNum);
            serializer.serialize(buffer, obj.numRounds);
            serializer.serialize(buffer, obj.time);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            double energy = buffer.getDouble();
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            double bodyHeading = buffer.getDouble();
            double gunHeading = buffer.getDouble();
            double radarHeading = buffer.getDouble();
            double velocity = buffer.getDouble();
            double bodyTurnRemaining = buffer.getDouble();
            double radarTurnRemaining = buffer.getDouble();
            double gunTurnRemaining = buffer.getDouble();
            double distanceRemaining = buffer.getDouble();
            double gunHeat = buffer.getDouble();
            int others = buffer.getInt();
            int numSentries = buffer.getInt();
            int roundNum = buffer.getInt();
            int numRounds = buffer.getInt();
            long time = buffer.getLong();
            return new RobotStatus(energy, x, y, bodyHeading, gunHeading, radarHeading, velocity, bodyTurnRemaining, radarTurnRemaining, gunTurnRemaining, distanceRemaining, gunHeat, others, numSentries, roundNum, numRounds, time);
        }

        @Override
        public RobotStatus createStatus(double energy, double x, double y, double bodyHeading, double gunHeading, double radarHeading, double velocity, double bodyTurnRemaining, double radarTurnRemaining, double gunTurnRemaining, double distanceRemaining, double gunHeat, int others, int numSentries, int roundNum, int numRounds, long time) {
            return new RobotStatus(energy, x, y, bodyHeading, gunHeading, radarHeading, velocity, bodyTurnRemaining, radarTurnRemaining, gunTurnRemaining, distanceRemaining, gunHeat, others, numSentries, roundNum, numRounds, time);
        }
    }
}

