/*
 * Decompiled with CFR 0.152.
 */
package robocode;

public final class Rules {
    public static final double ACCELERATION = 1.0;
    public static final double DECELERATION = 2.0;
    public static final double MAX_VELOCITY = 8.0;
    public static final double RADAR_SCAN_RADIUS = 1200.0;
    public static final double MIN_BULLET_POWER = 0.1;
    public static final double MAX_BULLET_POWER = 3.0;
    public static final double MAX_TURN_RATE = 10.0;
    public static final double MAX_TURN_RATE_RADIANS = Math.toRadians(10.0);
    public static final double GUN_TURN_RATE = 20.0;
    public static final double GUN_TURN_RATE_RADIANS = Math.toRadians(20.0);
    public static final double RADAR_TURN_RATE = 45.0;
    public static final double RADAR_TURN_RATE_RADIANS = Math.toRadians(45.0);
    public static final double ROBOT_HIT_DAMAGE = 0.6;
    public static final double ROBOT_HIT_BONUS = 1.2;

    private Rules() {
    }

    public static double getTurnRate(double velocity) {
        return 10.0 - 0.75 * Math.abs(velocity);
    }

    public static double getTurnRateRadians(double velocity) {
        return Math.toRadians(Rules.getTurnRate(velocity));
    }

    public static double getWallHitDamage(double velocity) {
        return Math.max(Math.abs(velocity) / 2.0 - 1.0, 0.0);
    }

    public static double getBulletDamage(double bulletPower) {
        double damage = 4.0 * bulletPower;
        if (bulletPower > 1.0) {
            damage += 2.0 * (bulletPower - 1.0);
        }
        return damage;
    }

    public static double getBulletHitBonus(double bulletPower) {
        return 3.0 * bulletPower;
    }

    public static double getBulletSpeed(double bulletPower) {
        bulletPower = Math.min(Math.max(bulletPower, 0.1), 3.0);
        return 20.0 - 3.0 * bulletPower;
    }

    public static double getGunHeat(double bulletPower) {
        return 1.0 + bulletPower / 5.0;
    }
}

