/*
 * Decompiled with CFR 0.152.
 */
package robocode;

import java.awt.Graphics2D;
import java.nio.ByteBuffer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.Event;
import robocode.robotinterfaces.IBasicEvents;
import robocode.robotinterfaces.IBasicRobot;

public class ScannedRobotEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PRIORITY = 10;
    private final String name;
    private final double energy;
    private final double heading;
    private final double bearing;
    private final double distance;
    private final double velocity;
    private final boolean isSentryRobot;

    public ScannedRobotEvent() {
        this(null, 0.0, 0.0, 0.0, 0.0, 0.0, false);
    }

    public ScannedRobotEvent(String name, double energy, double bearing, double distance, double heading, double velocity) {
        this(name, energy, bearing, distance, heading, velocity, false);
    }

    public ScannedRobotEvent(String name, double energy, double bearing, double distance, double heading, double velocity, boolean isSentryRobot) {
        this.name = name;
        this.energy = energy;
        this.bearing = bearing;
        this.distance = distance;
        this.heading = heading;
        this.velocity = velocity;
        this.isSentryRobot = isSentryRobot;
    }

    public double getBearing() {
        return this.bearing * 180.0 / Math.PI;
    }

    public double getBearingRadians() {
        return this.bearing;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getHeading() {
        return this.heading * 180.0 / Math.PI;
    }

    public double getHeadingRadians() {
        return this.heading;
    }

    @Deprecated
    public double getLife() {
        return this.energy;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public double getRobotBearing() {
        return this.getBearing();
    }

    @Deprecated
    public double getRobotBearingDegrees() {
        return this.getBearing();
    }

    @Deprecated
    public double getRobotBearingRadians() {
        return this.getBearingRadians();
    }

    @Deprecated
    public double getRobotDistance() {
        return this.getDistance();
    }

    @Deprecated
    public double getRobotHeading() {
        return this.getHeading();
    }

    @Deprecated
    public double getRobotHeadingDegrees() {
        return this.getHeading();
    }

    @Deprecated
    public double getRobotHeadingRadians() {
        return this.getHeadingRadians();
    }

    @Deprecated
    public double getRobotLife() {
        return this.getEnergy();
    }

    @Deprecated
    public String getRobotName() {
        return this.getName();
    }

    @Deprecated
    public double getRobotVelocity() {
        return this.getVelocity();
    }

    public double getVelocity() {
        return this.velocity;
    }

    public boolean isSentryRobot() {
        return this.isSentryRobot;
    }

    @Override
    public final int compareTo(Event event) {
        int res = super.compareTo(event);
        if (res != 0) {
            return res;
        }
        if (event instanceof ScannedRobotEvent) {
            return (int)(this.getDistance() - ((ScannedRobotEvent)event).getDistance());
        }
        return 0;
    }

    @Override
    final int getDefaultPriority() {
        return 10;
    }

    @Override
    final void dispatch(IBasicRobot robot, IRobotStatics statics, Graphics2D graphics) {
        IBasicEvents listener = robot.getBasicEventListener();
        if (listener != null) {
            listener.onScannedRobot(this);
        }
    }

    @Override
    byte getSerializationType() {
        return 41;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        @Override
        public int sizeOf(RbSerializer serializer, Object object) {
            ScannedRobotEvent obj = (ScannedRobotEvent)object;
            return 1 + serializer.sizeOf(obj.name) + 40 + 1;
        }

        @Override
        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            ScannedRobotEvent obj = (ScannedRobotEvent)object;
            serializer.serialize(buffer, obj.name);
            serializer.serialize(buffer, obj.energy);
            serializer.serialize(buffer, obj.heading);
            serializer.serialize(buffer, obj.bearing);
            serializer.serialize(buffer, obj.distance);
            serializer.serialize(buffer, obj.velocity);
            serializer.serialize(buffer, obj.isSentryRobot);
        }

        @Override
        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            String name = serializer.deserializeString(buffer);
            double energy = buffer.getDouble();
            double heading = buffer.getDouble();
            double bearing = buffer.getDouble();
            double distance = buffer.getDouble();
            double velocity = buffer.getDouble();
            boolean isSentryRobot = serializer.deserializeBoolean(buffer);
            return new ScannedRobotEvent(name, energy, bearing, distance, heading, velocity, isSentryRobot);
        }
    }
}

