/*
 * Decompiled with CFR 0.152.
 */
package robocode.control;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.robocode.battle.IBattleManagerBase;
import net.sf.robocode.core.ContainerBase;
import net.sf.robocode.gui.IWindowManagerBase;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.manager.IVersionManagerBase;
import net.sf.robocode.repository.IRepositoryManagerBase;
import net.sf.robocode.security.HiddenAccess;
import robocode.control.BattleSpecification;
import robocode.control.IRobocodeEngine;
import robocode.control.RobocodeListener;
import robocode.control.RobotResults;
import robocode.control.RobotSpecification;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleFinishedEvent;
import robocode.control.events.BattleMessageEvent;
import robocode.control.events.IBattleListener;

public class RobocodeEngine
implements IRobocodeEngine {
    private BattleObserver battleObserver;
    private BattleSpecification battleSpecification;
    private List<IBattleListener> listeners = new ArrayList<IBattleListener>();

    public RobocodeEngine() {
        this.init(null, (IBattleListener)null);
    }

    public RobocodeEngine(File robocodeHome) {
        this.init(robocodeHome, (IBattleListener)null);
    }

    @Deprecated
    public RobocodeEngine(File robocodeHome, RobocodeListener listener) {
        this.init(robocodeHome, listener);
    }

    @Deprecated
    public RobocodeEngine(RobocodeListener listener) {
        this.init(null, listener);
    }

    public RobocodeEngine(IBattleListener listener) {
        this.init(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void init(File robocodeHome, RobocodeListener listener) {
        if (listener != null) {
            this.battleObserver = new BattleObserver();
            this.battleObserver.listener = listener;
        }
        HiddenAccess.initContainerForRobotEngine(robocodeHome, this.battleObserver);
    }

    private void init(File robocodeHome, IBattleListener listener) {
        HiddenAccess.initContainerForRobotEngine(robocodeHome, listener);
    }

    @Override
    public void addBattleListener(IBattleListener listener) {
        this.listeners.add(listener);
        ContainerBase.getComponent(IBattleManagerBase.class).addListener(listener);
    }

    @Override
    public void removeBattleListener(IBattleListener listener) {
        this.listeners.remove(listener);
        ContainerBase.getComponent(IBattleManagerBase.class).removeListener(listener);
    }

    @Override
    public void close() {
        this.setVisible(false);
        if (this.battleObserver != null) {
            ContainerBase.getComponent(IBattleManagerBase.class).removeListener(this.battleObserver);
        }
        for (IBattleListener listener : this.listeners) {
            ContainerBase.getComponent(IBattleManagerBase.class).removeListener(listener);
        }
        this.listeners.clear();
        HiddenAccess.cleanup();
    }

    @Override
    public String getVersion() {
        return ContainerBase.getComponent(IVersionManagerBase.class).getVersion();
    }

    public static File getCurrentWorkingDir() {
        return FileUtil.getCwd();
    }

    public static File getRobotsDir() {
        return FileUtil.getRobotsDir();
    }

    @Override
    public void setVisible(boolean visible) {
        IWindowManagerBase windowManager = ContainerBase.getComponent(IWindowManagerBase.class);
        if (windowManager != null) {
            windowManager.setVisibleForRobotEngine(visible);
        } else {
            Logger.logError("setVisible: No window manager was found.\nPerhaps you are missing the robocode.ui-1.x.x.x-jar file or the GUI has been disabled?");
        }
    }

    @Override
    public RobotSpecification[] getLocalRepository() {
        IRepositoryManagerBase repository = ContainerBase.getComponent(IRepositoryManagerBase.class);
        repository.refresh();
        return repository.getSpecifications();
    }

    @Override
    public RobotSpecification[] getLocalRepository(String selectedRobots) {
        IRepositoryManagerBase repository = ContainerBase.getComponent(IRepositoryManagerBase.class);
        repository.refresh();
        return repository.loadSelectedRobots(selectedRobots);
    }

    @Override
    public void runBattle(BattleSpecification battleSpecification) {
        this.runBattle(battleSpecification, null, false);
    }

    @Override
    public void runBattle(BattleSpecification battleSpecification, boolean waitTillOver) {
        this.runBattle(battleSpecification, null, waitTillOver);
    }

    @Override
    public void runBattle(BattleSpecification battleSpecification, String initialPositions, boolean waitTillOver) {
        this.battleSpecification = battleSpecification;
        ContainerBase.getComponent(IBattleManagerBase.class).startNewBattle(battleSpecification, initialPositions, waitTillOver, false);
    }

    @Override
    public void waitTillBattleOver() {
        ContainerBase.getComponent(IBattleManagerBase.class).waitTillOver();
    }

    @Override
    public void abortCurrentBattle() {
        ContainerBase.getComponent(IBattleManagerBase.class).stop(true);
    }

    public static void printRunningThreads() {
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        if (currentGroup == null) {
            return;
        }
        while (currentGroup.getParent() != null) {
            currentGroup = currentGroup.getParent();
        }
        ThreadGroup[] groups = new ThreadGroup[256];
        Thread[] threads = new Thread[256];
        int numGroups = currentGroup.enumerate(groups, true);
        for (int i = 0; i < numGroups; ++i) {
            currentGroup = groups[i];
            if (currentGroup.isDaemon()) {
                Logger.realOut.print("  ");
            } else {
                Logger.realOut.print("* ");
            }
            Logger.realOut.println("In group: " + currentGroup.getName());
            int numThreads = currentGroup.enumerate(threads);
            for (int j = 0; j < numThreads; ++j) {
                if (threads[j].isDaemon()) {
                    Logger.realOut.print("  ");
                } else {
                    Logger.realOut.print("* ");
                }
                Logger.realOut.println(threads[j].getName());
            }
            Logger.realOut.println("---------------");
        }
    }

    public static void setLogMessagesEnabled(boolean enable) {
        System.setProperty("logMessages", "" + enable);
    }

    public static void setLogErrorsEnabled(boolean enable) {
        System.setProperty("logErrors", "" + enable);
    }

    private class BattleObserver
    extends BattleAdaptor {
        private RobocodeListener listener;

        private BattleObserver() {
        }

        @Override
        public void onBattleFinished(BattleFinishedEvent event) {
            if (event.isAborted()) {
                this.listener.battleAborted(RobocodeEngine.this.battleSpecification);
            }
        }

        @Override
        public void onBattleCompleted(BattleCompletedEvent event) {
            this.listener.battleComplete(RobocodeEngine.this.battleSpecification, RobotResults.convertResults(event.getSortedResults()));
        }

        @Override
        public void onBattleMessage(BattleMessageEvent event) {
            this.listener.battleMessage(event.getMessage());
        }
    }
}

