/*
 * Decompiled with CFR 0.152.
 */
package robocode.control;

import robocode.BattleResults;
import robocode.control.RobotSpecification;

public class RobotResults
extends BattleResults {
    private static final long serialVersionUID = 2L;
    private final RobotSpecification robot;

    public RobotResults(RobotSpecification robot, String teamLeaderName, int rank, double score, double survival, double lastSurvivorBonus, double bulletDamage, double bulletDamageBonus, double ramDamage, double ramDamageBonus, int firsts, int seconds, int thirds) {
        super(teamLeaderName, rank, score, survival, lastSurvivorBonus, bulletDamage, bulletDamageBonus, ramDamage, ramDamageBonus, firsts, seconds, thirds);
        this.robot = robot;
    }

    public RobotResults(RobotSpecification robot, BattleResults results) {
        super(results.getTeamLeaderName(), results.getRank(), results.getScore(), results.getSurvival(), results.getLastSurvivorBonus(), results.getBulletDamage(), results.getBulletDamageBonus(), results.getRamDamage(), results.getRamDamageBonus(), results.getFirsts(), results.getSeconds(), results.getThirds());
        this.robot = robot;
    }

    public RobotSpecification getRobot() {
        return this.robot;
    }

    public static RobotResults[] convertResults(BattleResults[] results) {
        RobotResults[] resultsConv = new RobotResults[results.length];
        for (int i = 0; i < results.length; ++i) {
            resultsConv[i] = (RobotResults)results[i];
        }
        return resultsConv;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.bulletDamage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.bulletDamageBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.firsts;
        temp = Double.doubleToLongBits(this.lastSurvivorBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.ramDamage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.ramDamageBonus);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.rank;
        temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.seconds;
        temp = Double.doubleToLongBits(this.survival);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.teamLeaderName == null ? 0 : this.teamLeaderName.hashCode());
        result = 31 * result + this.thirds;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RobotResults other = (RobotResults)obj;
        if (Double.doubleToLongBits(this.bulletDamage) != Double.doubleToLongBits(other.bulletDamage)) {
            return false;
        }
        if (Double.doubleToLongBits(this.bulletDamageBonus) != Double.doubleToLongBits(other.bulletDamageBonus)) {
            return false;
        }
        if (this.firsts != other.firsts) {
            return false;
        }
        if (Double.doubleToLongBits(this.lastSurvivorBonus) != Double.doubleToLongBits(other.lastSurvivorBonus)) {
            return false;
        }
        if (Double.doubleToLongBits(this.ramDamage) != Double.doubleToLongBits(other.ramDamage)) {
            return false;
        }
        if (Double.doubleToLongBits(this.ramDamageBonus) != Double.doubleToLongBits(other.ramDamageBonus)) {
            return false;
        }
        if (this.rank != other.rank) {
            return false;
        }
        if (Double.doubleToLongBits(this.score) != Double.doubleToLongBits(other.score)) {
            return false;
        }
        if (this.seconds != other.seconds) {
            return false;
        }
        if (Double.doubleToLongBits(this.survival) != Double.doubleToLongBits(other.survival)) {
            return false;
        }
        if (this.teamLeaderName == null ? other.teamLeaderName != null : !this.teamLeaderName.equals(other.teamLeaderName)) {
            return false;
        }
        return this.thirds == other.thirds;
    }
}

