/*
 * Decompiled with CFR 0.152.
 */
package robocode.control;

import java.io.File;
import java.io.Serializable;
import net.sf.robocode.security.IHiddenSpecificationHelper;

public class RobotSpecification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object fileSpecification;
    private final String name;
    private final String author;
    private final String webpage;
    private final String version;
    private final String robocodeVersion;
    private final String jarFile;
    private final String fullClassName;
    private final String description;
    private String teamId;

    private RobotSpecification(Object fileSpecification, String name, String author, String webpage, String version, String robocodeVersion, String jarFile, String fullClassName, String description) {
        this.fileSpecification = fileSpecification;
        this.name = name;
        this.author = author;
        this.webpage = webpage;
        this.version = version;
        this.robocodeVersion = robocodeVersion;
        this.jarFile = jarFile;
        this.fullClassName = fullClassName;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNameAndVersion() {
        String nameAndVersion = this.getName();
        String version = this.getVersion();
        if (version != null && version.trim().length() > 0) {
            nameAndVersion = nameAndVersion + ' ' + version.trim();
        }
        return nameAndVersion;
    }

    public String getClassName() {
        return this.fullClassName;
    }

    public File getJarFile() {
        return new File(this.jarFile);
    }

    public String getDescription() {
        return this.description;
    }

    public String getRobocodeVersion() {
        return this.robocodeVersion;
    }

    public String getWebpage() {
        return this.webpage;
    }

    public String getAuthorName() {
        return this.author;
    }

    public String getTeamId() {
        return this.teamId != null ? this.teamId : this.getNameAndVersion();
    }

    static IHiddenSpecificationHelper createHiddenHelper() {
        return new HiddenHelper();
    }

    private static class HiddenHelper
    implements IHiddenSpecificationHelper {
        private HiddenHelper() {
        }

        @Override
        public RobotSpecification createSpecification(Object fileSpecification, String name, String author, String webpage, String version, String robocodeVersion, String jarFile, String fullClassName, String description) {
            return new RobotSpecification(fileSpecification, name, author, webpage, version, robocodeVersion, jarFile, fullClassName, description);
        }

        @Override
        public Object getFileSpecification(RobotSpecification specification) {
            return specification.fileSpecification;
        }

        @Override
        public void setTeamName(RobotSpecification specification, String teamName) {
            specification.teamId = teamName;
        }

        @Override
        public String getTeamName(RobotSpecification specification) {
            return specification.teamId;
        }
    }
}

