/*
 * Decompiled with CFR 0.152.
 */
package robocode.util;

import java.util.Random;
import robocode.control.RandomFactory;

public class Utils {
    private static final double TWO_PI = Math.PI * 2;
    private static final double THREE_PI_OVER_TWO = 4.71238898038469;
    private static final double PI_OVER_TWO = 1.5707963267948966;
    public static final double NEAR_DELTA = 1.0E-5;

    private Utils() {
    }

    public static double normalAbsoluteAngle(double angle) {
        double d;
        return d >= 0.0 ? angle : (angle %= Math.PI * 2) + Math.PI * 2;
    }

    public static double normalAbsoluteAngleDegrees(double angle) {
        double d;
        return d >= 0.0 ? angle : (angle %= 360.0) + 360.0;
    }

    public static double normalRelativeAngle(double angle) {
        double d;
        return d >= 0.0 ? (angle < Math.PI ? angle : angle - Math.PI * 2) : (angle >= -Math.PI ? angle : (angle %= Math.PI * 2) + Math.PI * 2);
    }

    public static double normalRelativeAngleDegrees(double angle) {
        double d;
        return d >= 0.0 ? (angle < 180.0 ? angle : angle - 360.0) : (angle >= -180.0 ? angle : (angle %= 360.0) + 360.0);
    }

    public static double normalNearAbsoluteAngleDegrees(double angle) {
        double d;
        angle %= 360.0;
        double d2 = angle = d >= 0.0 ? angle : angle + 360.0;
        if (Utils.isNear(angle, 180.0)) {
            return 180.0;
        }
        if (angle < 180.0) {
            if (Utils.isNear(angle, 0.0)) {
                return 0.0;
            }
            if (Utils.isNear(angle, 90.0)) {
                return 90.0;
            }
        } else {
            if (Utils.isNear(angle, 270.0)) {
                return 270.0;
            }
            if (Utils.isNear(angle, 360.0)) {
                return 0.0;
            }
        }
        return angle;
    }

    public static double normalNearAbsoluteAngle(double angle) {
        double d;
        angle %= Math.PI * 2;
        double d2 = angle = d >= 0.0 ? angle : angle + Math.PI * 2;
        if (Utils.isNear(angle, Math.PI)) {
            return Math.PI;
        }
        if (angle < Math.PI) {
            if (Utils.isNear(angle, 0.0)) {
                return 0.0;
            }
            if (Utils.isNear(angle, 1.5707963267948966)) {
                return 1.5707963267948966;
            }
        } else {
            if (Utils.isNear(angle, 4.71238898038469)) {
                return 4.71238898038469;
            }
            if (Utils.isNear(angle, Math.PI * 2)) {
                return 0.0;
            }
        }
        return angle;
    }

    public static boolean isNear(double value1, double value2) {
        return Math.abs(value1 - value2) < 1.0E-5;
    }

    public static Random getRandom() {
        return RandomFactory.getRandom();
    }
}

