/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.awt.Toolkit;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sf.robocode.core.ContainerBase;
import net.sf.robocode.core.EngineClassLoader;
import net.sf.robocode.core.IModule;
import net.sf.robocode.io.Logger;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;

public final class Container
extends ContainerBase {
    private static final String classPath = System.getProperties().getProperty("robocode.class.path", null);
    public static final MutablePicoContainer cache;
    public static final MutablePicoContainer factory;
    public static final ClassLoader systemLoader;
    private static final ClassLoader engineLoader;
    private static Set<String> known;
    private static final List<IModule> modules;

    static void init() {
    }

    private static void loadFromPath(String path) {
        try {
            File pathf = new File(path).getCanonicalFile();
            path = pathf.toString();
            String test = path.toLowerCase();
            if (pathf.isDirectory()) {
                String name = Container.getModuleName(path);
                if (name != null) {
                    Container.loadModule(name, engineLoader);
                }
            } else if (test.contains(File.separator + "robocode.") && test.endsWith(".jar")) {
                int i = test.lastIndexOf("robocode.jar");
                if (i > 0) {
                    File dir = new File(path.substring(0, i));
                    Logger.logMessage((String)("Loading plugins from " + dir.toString()));
                    Container.loadJars(dir);
                } else {
                    String name = Container.getModuleName(path);
                    if (name != null) {
                        Container.loadModule(name, engineLoader);
                    }
                }
            }
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
    }

    private static void loadJars(File pathf) {
        File[] files;
        for (File file : files = pathf.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith("robocode") && name.toLowerCase().endsWith(".jar");
            }
        })) {
            Container.loadModule(Container.getModuleName(file.toString()), engineLoader);
        }
    }

    private static boolean loadModule(String module, ClassLoader loader) {
        try {
            if (known.contains(module)) {
                return false;
            }
            Class<?> modClass = loader.loadClass(module + ".Module");
            Object moduleInstance = modClass.newInstance();
            if (moduleInstance instanceof IModule) {
                modules.add((IModule)moduleInstance);
            }
            Logger.logMessage((String)("Loaded " + module));
            known.add(module);
            return true;
        }
        catch (ClassNotFoundException modClass) {
        }
        catch (IllegalAccessException e) {
            Logger.logError((Throwable)e);
        }
        catch (InstantiationException e) {
            Logger.logError((Throwable)e);
        }
        return false;
    }

    private static String getModuleName(String path) {
        String test = path.toLowerCase();
        if (test.endsWith("robocode.jar") || test.contains("robocode.api")) {
            return null;
        }
        int i = test.lastIndexOf("robocode.");
        if (i > 0) {
            String name = path.substring(i);
            if ((i = name.indexOf(File.separator)) > 0) {
                return "net.sf." + name.substring(0, i);
            }
            i = name.indexOf("-");
            if (i > 0) {
                return "net.sf." + name.substring(0, i);
            }
            return "net.sf." + name;
        }
        return null;
    }

    static URL[] findJars(String allowed) {
        ArrayList<String> urls = new ArrayList<String>();
        String classPath = System.getProperty("robocode.class.path", null);
        for (String path : classPath.split(File.pathSeparator)) {
            String test = path.toLowerCase();
            if (!test.contains(allowed) || test.contains("robocode.jar") || test.contains("robocode.api")) continue;
            urls.add(path);
        }
        return Container.convertUrls(urls);
    }

    private static URL[] convertUrls(List<String> surls) {
        URL[] urls = new URL[surls.size()];
        for (int i = 0; i < surls.size(); ++i) {
            String url = surls.get(i);
            File f = new File(url);
            try {
                urls[i] = f.getCanonicalFile().toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                Logger.logError((Throwable)e);
                continue;
            }
            catch (IOException e) {
                Logger.logError((Throwable)e);
            }
        }
        return urls;
    }

    protected <T> T getBaseComponent(Class<T> tClass) {
        return (T)cache.getComponent(tClass);
    }

    public static <T> T getComponent(Class<T> tClass) {
        return (T)cache.getComponent(tClass);
    }

    public static <T> T getComponent(Class<T> tClass, String className) {
        List list = cache.getComponents(tClass);
        for (Object component : list) {
            if (!component.getClass().getName().endsWith(className)) continue;
            return (T)component;
        }
        return null;
    }

    public static <T> List<T> getComponents(Class<T> tClass) {
        return cache.getComponents(tClass);
    }

    public static <T> T createComponent(Class<T> tClass) {
        return (T)factory.as(new Properties[]{Characteristics.NO_CACHE}).getComponent(tClass);
    }

    static {
        known = new HashSet<String>();
        modules = new ArrayList<IModule>();
        instance = new Container();
        systemLoader = Container.class.getClassLoader();
        engineLoader = new EngineClassLoader(systemLoader);
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(engineLoader);
        currentThread.setName("Application Thread");
        Toolkit.getDefaultToolkit();
        cache = new DefaultClassLoadingPicoContainer(engineLoader, (ComponentFactory)new Caching(), null);
        factory = new DefaultClassLoadingPicoContainer(engineLoader, (ComponentFactory)new OptInCaching(), (PicoContainer)cache);
        Container.loadModule("net.sf.robocode.api", systemLoader);
        String[] cp = classPath.split(File.pathSeparator);
        for (String path : cp) {
            if (!path.toLowerCase().contains("robocode.core")) continue;
            Container.loadFromPath(path);
        }
        for (String path : cp) {
            Container.loadFromPath(path);
        }
        if (known.size() < 2) {
            Logger.logError((String)("Main modules not loaded, something went wrong. We have only " + known.size() + " modules"));
            Logger.logError((String)("Class path: " + classPath));
            throw new Error("Main modules not loaded");
        }
        for (IModule module : modules) {
            module.afterLoaded(modules);
        }
    }
}

