/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.core.RobocodeMainBase;
import net.sf.robocode.io.RobocodeProperties;

public class EngineClassLoader
extends URLClassLoader {
    private static Set<String> exclusions = new HashSet<String>();

    public EngineClassLoader(ClassLoader parent) {
        super(Container.findJars(File.separator + "robocode."), parent);
    }

    @Override
    public synchronized void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (RobocodeProperties.isSecurityOff() || name.startsWith("java.lang")) {
            return super.loadClass(name, resolve);
        }
        if (this.isEngineClass(name)) {
            return this.loadEngineClass(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    private Class<?> loadEngineClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            result = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private boolean isEngineClass(String name) {
        if (name.startsWith("net.sf.robocode") || name.startsWith("robocode.control")) {
            if (exclusions.contains(name)) {
                return false;
            }
            final String path = name.replace('.', '/').concat(".class");
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return EngineClassLoader.this.findResource(path) != null;
                }
            });
        }
        return false;
    }

    static {
        exclusions.add(EngineClassLoader.class.getName());
        exclusions.add(Container.class.getName());
        exclusions.add(RobocodeMainBase.class.getName());
        exclusions.add("net.sf.robocode.host.IHost");
        exclusions.add("net.sf.robocode.host.IHostManager");
        exclusions.add("net.sf.robocode.host.proxies.IHostingRobotProxy");
        exclusions.add("net.sf.robocode.peer.IRobotPeer");
        exclusions.add("net.sf.robocode.repository.IRobotItem");
        exclusions.add("net.sf.robocode.repository.RobotType");
        exclusions.add("net.sf.robocode.host.RobotStatics");
        exclusions.add("net.sf.robocode.peer.BadBehavior");
        exclusions.add("net.sf.robocode.host.proxies.__IHostingRobotProxy");
    }
}

