/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.repository.IRobotItem;
import net.sf.robocode.security.HiddenAccess;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;
import robocode.BattleRules;
import robocode.control.RobotSpecification;

public final class RobotStatics
implements IRobotStatics,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String robocodeVersion;
    private final boolean isJuniorRobot;
    private final boolean isAdvancedRobot;
    private final boolean isTeamRobot;
    private final boolean isDroid;
    private final boolean isSentryRobot;
    private final boolean isInteractiveRobot;
    private final boolean isPaintRobot;
    private final boolean isTeamLeader;
    private final String name;
    private final String shortName;
    private final String veryShortName;
    private final String fullClassName;
    private final String shortClassName;
    private final BattleRules battleRules;
    private final String[] teammates;
    private final String teamName;
    private final int robotIndex;
    private final int teamIndex;

    public RobotStatics(RobotSpecification robotSpecification, boolean isLeader, BattleRules rules, String teamName, List<String> teamMembers, int robotIndex, int teamIndex) {
        IRobotItem robotItem = (IRobotItem)HiddenAccess.getFileSpecification((RobotSpecification)robotSpecification);
        this.robotIndex = robotIndex;
        this.teamIndex = teamIndex;
        this.shortClassName = robotItem.getShortClassName();
        this.fullClassName = robotItem.getFullClassName();
        String suffix = " (" + (robotIndex + 1) + ")";
        this.name = robotItem.getUniqueFullClassNameWithVersion() + suffix;
        this.shortName = robotItem.getUniqueShortClassNameWithVersion() + suffix;
        this.veryShortName = robotItem.getUniqueVeryShortClassNameWithVersion() + suffix;
        this.robocodeVersion = robotItem.getRobocodeVersion();
        this.isJuniorRobot = robotItem.isJuniorRobot();
        this.isAdvancedRobot = robotItem.isAdvancedRobot();
        this.isTeamRobot = robotItem.isTeamRobot();
        this.isDroid = robotItem.isDroid();
        this.isSentryRobot = robotItem.isSentryRobot();
        this.isInteractiveRobot = robotItem.isInteractiveRobot();
        this.isPaintRobot = robotItem.isPaintRobot();
        this.isTeamLeader = isLeader;
        this.battleRules = rules;
        if (teamMembers != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String mate : teamMembers) {
                if (this.name.equals(mate)) continue;
                list.add(mate);
            }
            this.teammates = list.toArray(new String[0]);
            this.teamName = teamName;
        } else {
            this.teammates = null;
            this.teamName = this.name;
        }
    }

    private RobotStatics(String robocodeVersion, boolean isJuniorRobot, boolean isInteractiveRobot, boolean isPaintRobot, boolean isAdvancedRobot, boolean isTeamRobot, boolean isTeamLeader, boolean isDroid, boolean isSentryRobot, String name, String shortName, String veryShortName, String fullClassName, String shortClassName, BattleRules battleRules, String[] teammates, String teamName, int robotIndex, int teamIndex) {
        this.robocodeVersion = robocodeVersion;
        this.isJuniorRobot = isJuniorRobot;
        this.isAdvancedRobot = isAdvancedRobot;
        this.isTeamRobot = isTeamRobot;
        this.isDroid = isDroid;
        this.isSentryRobot = isSentryRobot;
        this.isInteractiveRobot = isInteractiveRobot;
        this.isPaintRobot = isPaintRobot;
        this.isTeamLeader = isTeamLeader;
        this.name = name;
        this.shortName = shortName;
        this.veryShortName = veryShortName;
        this.fullClassName = fullClassName;
        this.shortClassName = shortClassName;
        this.battleRules = battleRules;
        this.teammates = teammates;
        this.teamName = teamName;
        this.robotIndex = robotIndex;
        this.teamIndex = teamIndex;
    }

    public String getRobocodeVersion() {
        return this.robocodeVersion;
    }

    public String getAnnonymousName() {
        return "#" + this.robotIndex;
    }

    public boolean isJuniorRobot() {
        return this.isJuniorRobot;
    }

    public boolean isAdvancedRobot() {
        return this.isAdvancedRobot;
    }

    public boolean isTeamRobot() {
        return this.isTeamRobot;
    }

    public boolean isDroid() {
        return this.isDroid;
    }

    public boolean isSentryRobot() {
        return this.isSentryRobot;
    }

    public boolean isInteractiveRobot() {
        return this.isInteractiveRobot;
    }

    public boolean isPaintRobot() {
        return this.isPaintRobot;
    }

    public boolean isTeamLeader() {
        return this.isTeamLeader;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getVeryShortName() {
        return this.veryShortName;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public BattleRules getBattleRules() {
        return this.battleRules;
    }

    public String[] getTeammates() {
        return this.teammates == null ? null : (String[])this.teammates.clone();
    }

    public String getTeamName() {
        return this.teamName;
    }

    public int getRobotIndex() {
        return this.robotIndex;
    }

    public int getTeamIndex() {
        return this.teamIndex;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            RobotStatics obj = (RobotStatics)object;
            int size = 1 + serializer.sizeOf(obj.robocodeVersion) + 8 + serializer.sizeOf(obj.name) + serializer.sizeOf(obj.shortName) + serializer.sizeOf(obj.veryShortName) + serializer.sizeOf(obj.fullClassName) + serializer.sizeOf(obj.shortClassName) + 16 + 8 + 8 + 1;
            if (obj.teammates != null) {
                for (String mate : obj.teammates) {
                    size += serializer.sizeOf(mate);
                }
            }
            size += 4;
            size += serializer.sizeOf(obj.teamName);
            return size += 8;
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            RobotStatics obj = (RobotStatics)object;
            serializer.serialize(buffer, obj.robocodeVersion);
            serializer.serialize(buffer, obj.isJuniorRobot);
            serializer.serialize(buffer, obj.isInteractiveRobot);
            serializer.serialize(buffer, obj.isPaintRobot);
            serializer.serialize(buffer, obj.isAdvancedRobot);
            serializer.serialize(buffer, obj.isTeamRobot);
            serializer.serialize(buffer, obj.isTeamLeader);
            serializer.serialize(buffer, obj.isDroid);
            serializer.serialize(buffer, obj.isSentryRobot);
            serializer.serialize(buffer, obj.name);
            serializer.serialize(buffer, obj.shortName);
            serializer.serialize(buffer, obj.veryShortName);
            serializer.serialize(buffer, obj.fullClassName);
            serializer.serialize(buffer, obj.shortClassName);
            serializer.serialize(buffer, obj.battleRules.getBattlefieldWidth());
            serializer.serialize(buffer, obj.battleRules.getBattlefieldHeight());
            serializer.serialize(buffer, obj.battleRules.getNumRounds());
            serializer.serialize(buffer, obj.battleRules.getGunCoolingRate());
            serializer.serialize(buffer, obj.battleRules.getInactivityTime());
            serializer.serialize(buffer, obj.battleRules.getHideEnemyNames());
            serializer.serialize(buffer, obj.battleRules.getSentryBorderSize());
            if (obj.teammates != null) {
                for (String mate : obj.teammates) {
                    serializer.serialize(buffer, mate);
                }
            }
            buffer.putInt(-1);
            serializer.serialize(buffer, obj.teamName);
            serializer.serialize(buffer, obj.robotIndex);
            serializer.serialize(buffer, obj.teamIndex);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            String robocodeVersion = serializer.deserializeString(buffer);
            boolean isJuniorRobot = serializer.deserializeBoolean(buffer);
            boolean isInteractiveRobot = serializer.deserializeBoolean(buffer);
            boolean isPaintRobot = serializer.deserializeBoolean(buffer);
            boolean isAdvancedRobot = serializer.deserializeBoolean(buffer);
            boolean isTeamRobot = serializer.deserializeBoolean(buffer);
            boolean isTeamLeader = serializer.deserializeBoolean(buffer);
            boolean isDroid = serializer.deserializeBoolean(buffer);
            boolean isSentryRobot = serializer.deserializeBoolean(buffer);
            String name = serializer.deserializeString(buffer);
            String shortName = serializer.deserializeString(buffer);
            String veryShortName = serializer.deserializeString(buffer);
            String fullClassName = serializer.deserializeString(buffer);
            String shortClassName = serializer.deserializeString(buffer);
            BattleRules battleRules = HiddenAccess.createRules((int)serializer.deserializeInt(buffer), (int)serializer.deserializeInt(buffer), (int)serializer.deserializeInt(buffer), (double)serializer.deserializeDouble(buffer), (long)serializer.deserializeLong(buffer), (boolean)serializer.deserializeBoolean(buffer), (int)serializer.deserializeInt(buffer));
            ArrayList<String> teammates = new ArrayList<String>();
            String item = serializer.deserializeString(buffer);
            if (item == null) {
                teammates = null;
            }
            while (item != null) {
                if (item instanceof String) {
                    teammates.add(item);
                }
                item = serializer.deserializeString(buffer);
            }
            String teamName = serializer.deserializeString(buffer);
            int robotIndex = serializer.deserializeInt(buffer);
            int teamIndex = serializer.deserializeInt(buffer);
            return new RobotStatics(robocodeVersion, isJuniorRobot, isInteractiveRobot, isPaintRobot, isAdvancedRobot, isTeamRobot, isTeamLeader, isDroid, isSentryRobot, name, shortName, veryShortName, fullClassName, shortClassName, battleRules, teammates.toArray(new String[teammates.size()]), teamName, robotIndex, teamIndex);
        }
    }
}

