/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle;

import javax.swing.table.AbstractTableModel;
import robocode.control.snapshot.IScoreSnapshot;
import robocode.control.snapshot.ITurnSnapshot;

public class BattleRankingTableModel
extends AbstractTableModel {
    private IScoreSnapshot[] scoreSnapshotList;
    private double currentSum;
    private double totalSum;

    private void countTotalScores() {
        this.currentSum = 0.0;
        this.totalSum = 0.0;
        for (IScoreSnapshot score : this.scoreSnapshotList) {
            this.currentSum += score.getCurrentScore();
            this.totalSum += score.getTotalScore();
        }
    }

    public void updateSource(ITurnSnapshot snapshot) {
        if (snapshot != null) {
            this.scoreSnapshotList = snapshot.getSortedTeamScores();
            this.countTotalScores();
        } else {
            this.scoreSnapshotList = null;
        }
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public int getRowCount() {
        return this.scoreSnapshotList == null ? 0 : this.scoreSnapshotList.length;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Rank";
            }
            case 1: {
                return "Robot Name";
            }
            case 2: {
                return "          Total Score          ";
            }
            case 3: {
                return "     Survival     ";
            }
            case 4: {
                return "Surv Bonus";
            }
            case 5: {
                return "    Bullet Dmg    ";
            }
            case 6: {
                return " Bullet Bonus ";
            }
            case 7: {
                return "Ram Dmg * 2";
            }
            case 8: {
                return "Ram Bonus";
            }
            case 9: {
                return " 1sts ";
            }
            case 10: {
                return " 2nds ";
            }
            case 11: {
                return " 3rds ";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        IScoreSnapshot statistics = this.scoreSnapshotList[row];
        switch (col) {
            case 0: {
                return BattleRankingTableModel.getPlacementString(row + 1);
            }
            case 1: {
                return statistics.getName();
            }
            case 2: {
                double current = statistics.getCurrentScore();
                double total = statistics.getTotalScore();
                return (int)(current + 0.5) + " / " + (int)(total + current + 0.5) + "  (" + (int)(current / this.currentSum * 100.0) + " / " + (int)((total + current) / (this.totalSum + this.currentSum) * 100.0) + "%)";
            }
            case 3: {
                double current = statistics.getCurrentSurvivalScore();
                double total = statistics.getTotalSurvivalScore();
                return (int)(current + 0.5) + " / " + (int)(total + current + 0.5);
            }
            case 4: {
                return (int)(statistics.getTotalLastSurvivorBonus() + 0.5);
            }
            case 5: {
                double current = statistics.getCurrentBulletDamageScore();
                double total = statistics.getTotalBulletDamageScore();
                return (int)(current + 0.5) + " / " + (int)(total + current + 0.5);
            }
            case 6: {
                double current = statistics.getCurrentBulletKillBonus();
                double total = statistics.getTotalBulletKillBonus();
                return (int)(current + 0.5) + " / " + (int)(total + current + 0.5);
            }
            case 7: {
                double current = statistics.getCurrentRammingDamageScore();
                double total = statistics.getTotalRammingDamageScore();
                return (int)(current + 0.5) + " / " + (int)(total + current + 0.5);
            }
            case 8: {
                double current = statistics.getCurrentRammingKillBonus();
                double total = statistics.getTotalRammingKillBonus();
                return (int)(current + 0.5) + " / " + (int)(total + current + 0.5);
            }
            case 9: {
                return "" + statistics.getTotalFirsts();
            }
            case 10: {
                return "" + statistics.getTotalSeconds();
            }
            case 11: {
                return "" + statistics.getTotalThirds();
            }
        }
        return "";
    }

    private static String getPlacementString(int i) {
        String result = "" + i;
        result = i > 3 && i < 20 ? result + "th" : (i % 10 == 1 ? result + "st" : (i % 10 == 2 ? result + "nd" : (i % 10 == 3 ? result + "rd" : result + "th")));
        return result;
    }
}

