/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import net.sf.robocode.battle.BattleResultsTableModel;
import net.sf.robocode.battle.IBattleManager;
import net.sf.robocode.core.Container;
import net.sf.robocode.core.RobocodeMainBase;
import net.sf.robocode.host.ICpuManager;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.RobocodeProperties;
import net.sf.robocode.recording.BattleRecordFormat;
import net.sf.robocode.recording.IRecordManager;
import net.sf.robocode.repository.IRepositoryManager;
import net.sf.robocode.serialization.SerializableOptions;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.sound.ISoundManager;
import net.sf.robocode.ui.IWindowManager;
import net.sf.robocode.util.StringUtil;
import net.sf.robocode.version.IVersionManager;
import robocode.control.events.BattleAdaptor;
import robocode.control.events.BattleCompletedEvent;
import robocode.control.events.BattleErrorEvent;
import robocode.control.events.BattleMessageEvent;
import robocode.control.events.BattleStartedEvent;
import robocode.control.events.IBattleListener;

public final class RobocodeMain
extends RobocodeMainBase {
    private final Setup setup;
    private final BattleObserver battleObserver = new BattleObserver();
    private final ISettingsManager properties;
    private final IHostManager hostManager;
    private final IWindowManager windowManager;
    private final ISoundManager soundManager;
    private final IBattleManager battleManager;
    private final IRecordManager recordManager;
    private final IVersionManager versionManager;

    public RobocodeMain(ISettingsManager properties, IHostManager hostManager, IWindowManager windowManager, ISoundManager soundManager, IBattleManager battleManager, IRecordManager recordManager, IVersionManager versionManager) {
        this.setup = new Setup();
        this.properties = properties;
        this.hostManager = hostManager;
        this.windowManager = windowManager;
        this.soundManager = soundManager;
        this.battleManager = battleManager;
        this.recordManager = recordManager;
        this.versionManager = versionManager;
    }

    public RobocodeMain(ISettingsManager properties, IHostManager hostManager, IWindowManager windowManager, IBattleManager battleManager, IRecordManager recordManager, IVersionManager versionManager) {
        this(properties, hostManager, windowManager, null, battleManager, recordManager, versionManager);
    }

    public RobocodeMain(ISettingsManager properties, IHostManager hostManager, IBattleManager battleManager, IRecordManager recordManager, IVersionManager versionManager) {
        this(properties, hostManager, null, battleManager, recordManager, versionManager);
    }

    @Override
    public void run() {
        Thread.setDefaultUncaughtExceptionHandler((thread, t) -> t.printStackTrace());
        try {
            boolean enableCLIRecording;
            this.hostManager.initSecurity();
            if (this.windowManager != null && this.windowManager.isGUIEnabled()) {
                this.windowManager.init();
            }
            this.properties.setOptionsBattleDesiredTPS(this.setup.tps);
            this.battleManager.addListener((IBattleListener)this.battleObserver);
            if (this.windowManager != null && this.windowManager.isGUIEnabled()) {
                if (!this.setup.minimize && this.setup.battleFilename == null && this.soundManager != null) {
                    this.soundManager.playThemeMusic();
                    this.windowManager.showSplashScreen();
                }
                this.windowManager.showRobocodeFrame(true, this.setup.minimize);
                if (this.setup.battleFilename == null && this.versionManager.isLastRunVersionChanged()) {
                    this.properties.saveProperties();
                    this.windowManager.runIntroBattle();
                }
            }
            boolean bl = enableCLIRecording = this.setup.recordFilename != null || this.setup.recordXmlFilename != null;
            if (this.setup.battleFilename != null) {
                if (this.setup.replayFilename != null) {
                    System.err.println("You cannot run both a battle and replay a battle record in the same time.");
                    System.exit(8);
                }
                this.setup.exitOnComplete = true;
                this.battleManager.setBattleFilename(this.setup.battleFilename);
                if (new File(this.battleManager.getBattleFilename()).exists()) {
                    this.battleManager.startNewBattle(this.battleManager.loadBattleProperties(), false, enableCLIRecording);
                } else {
                    System.err.println("The specified battle file '" + this.setup.battleFilename + "' was not found");
                    System.exit(8);
                }
            } else if (this.setup.replayFilename != null) {
                this.setup.exitOnComplete = true;
                if (this.setup.replayFilename.toLowerCase().endsWith("xml.zip")) {
                    this.recordManager.loadRecord(this.setup.replayFilename, BattleRecordFormat.XML_ZIP);
                } else {
                    this.recordManager.loadRecord(this.setup.replayFilename, BattleRecordFormat.BINARY_ZIP);
                }
                if (new File(this.setup.replayFilename).exists()) {
                    this.battleManager.replay();
                } else {
                    Logger.logError((String)("The specified battle record file '" + this.setup.replayFilename + "' was not found"));
                    System.exit(8);
                }
            }
            Logger.initialized = true;
        }
        catch (Throwable e) {
            Logger.logError((Throwable)e);
        }
    }

    @Override
    public void loadSetup(String[] args) {
        String osName;
        boolean isWindows;
        this.setup.tps = this.properties.getOptionsBattleDesiredTPS();
        if (GraphicsEnvironment.isHeadless()) {
            if (this.windowManager != null) {
                this.windowManager.setEnableGUI(false);
                Logger.logWarning((String)"Disabled GUI on headless system");
            }
            if (this.soundManager != null) {
                this.soundManager.setEnableSound(false);
            }
        }
        if (isWindows = (osName = System.getProperty("os.name").toLowerCase()).startsWith("windows ")) {
            System.setProperty("sun.io.useCanonCaches", "false");
        }
        System.setProperty("java.awt.headless", "false");
        for (int i = 0; i < args.length; ++i) {
            String currentArg = args[i];
            if (currentArg.equalsIgnoreCase("-cwd") && i < args.length + 1) {
                this.changeDirectory(args[i + 1]);
                ++i;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-battle") && i < args.length + 1) {
                this.setup.battleFilename = args[i + 1];
                ++i;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-record") && i < args.length + 1) {
                this.setup.recordFilename = args[i + 1];
                ++i;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-recordXML") && i < args.length + 1) {
                this.setup.recordXmlFilename = args[i + 1];
                ++i;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-replay") && i < args.length + 1) {
                this.setup.replayFilename = args[i + 1];
                ++i;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-results") && i < args.length + 1) {
                this.setup.resultsFilename = args[i + 1];
                ++i;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-tps") && i < args.length + 1) {
                this.setup.tps = Integer.parseInt(args[i + 1]);
                if (this.setup.tps < 1) {
                    Logger.logError((String)"tps must be > 0");
                    System.exit(8);
                }
                ++i;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-minimize")) {
                this.setup.minimize = true;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-nodisplay")) {
                if (this.windowManager != null) {
                    this.windowManager.setEnableGUI(false);
                }
                if (this.soundManager != null) {
                    this.soundManager.setEnableSound(false);
                }
                this.setup.tps = 10000;
                continue;
            }
            if (currentArg.equalsIgnoreCase("-nosound")) {
                if (this.soundManager == null) continue;
                this.soundManager.setEnableSound(false);
                continue;
            }
            if (currentArg.equals("-?") || currentArg.equalsIgnoreCase("-help")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            Logger.logError((String)("Not understood: " + currentArg));
            this.printUsage();
            System.exit(8);
        }
        File robotsDir = FileUtil.getRobotsDir();
        if (robotsDir == null) {
            System.err.println("No valid robot directory is specified");
            System.exit(8);
        } else if (!robotsDir.exists() || !robotsDir.isDirectory()) {
            System.err.println('\'' + robotsDir.getAbsolutePath() + "' is not a valid robot directory");
            System.exit(8);
        }
        Toolkit.getDefaultToolkit();
        String nosecMessage = "Robocode is running without a security manager.\n  Robots have full access to your system.\n  You should only run robots which you trust!";
        String exMessage = "Robocode is running in experimental mode.\n  Robots have access to their IRobotPeer interfaces.\n  You should only run robots which you trust!";
        if (RobocodeProperties.isSecurityOff()) {
            RobocodeMain.addRobotsDirToClassPath();
            System.out.println("Warning: Robocode is running without a security manager.\n  Robots have full access to your system.\n  You should only run robots which you trust!");
            Logger.logWarning((String)"Robocode is running without a security manager.\n  Robots have full access to your system.\n  You should only run robots which you trust!");
        }
        if (System.getProperty("EXPERIMENTAL", "false").equals("true")) {
            System.out.println("Warning: Robocode is running in experimental mode.\n  Robots have access to their IRobotPeer interfaces.\n  You should only run robots which you trust!");
            Logger.logWarning((String)"Robocode is running in experimental mode.\n  Robots have access to their IRobotPeer interfaces.\n  You should only run robots which you trust!");
        }
    }

    public static void addRobotsDirToClassPath() {
        File robotsDir = FileUtil.getRobotsDir();
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, robotsDir.toURI().toURL());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void changeDirectory(String robocodeDir) {
        try {
            FileUtil.setCwd((File)new File(robocodeDir));
        }
        catch (IOException e) {
            System.err.println(robocodeDir + " is not a valid directory to start Robocode in.");
            System.exit(8);
        }
    }

    private void printUsage() {
        System.out.print("Usage: robocode [-?] [-help] [-cwd path] [-battle filename [-results filename]\n                [-record filename] [-recordXML filename] [-replay filename]\n                [-tps tps] [-minimize] [-nodisplay] [-nosound]\n\nwhere options include:\n  -? or -help                Prints out the command line usage of Robocode\n  -cwd <path>                Change the current working directory\n  -battle <battle file>      Run the battle specified in a battle file\n  -results <results file>    Save results to the specified text file\n  -record <bin record file>  Record the battle into the specified file as binary\n  -recordXML <xml rec file>  Record the battle into the specified file as XML\n  -replay <record file>      Replay the specified battle record\n  -tps <tps>                 Set the TPS > 0 (Turns Per Second)\n  -minimize                  Run minimized when Robocode starts\n  -nodisplay                 Run with the display / GUI disabled\n  -nosound                   Run with sound disabled\n\nJava Properties include:\n  -DWORKINGDIRECTORY=<path>  Set the working directory\n  -DROBOTPATH=<path>         Set the robots directory (default is 'robots')\n  -DBATTLEPATH=<path>        Set the battles directory (default is 'battles')\n  -DNOSECURITY=true|false    Enable/disable Robocode's security manager\n  -Ddebug=true|false         Enable/disable debugging used for preventing\n                             robot timeouts and skipped turns, and allows an\n                             an unlimited painting buffer when debugging robots\n  -DPAINTING=true|false      Enable/disable painting all robot painting on the\n                             screen per default.\n  -DlogMessages=true|false   Log messages and warnings will be disabled\n  -DlogErrors=true|false     Log errors will be disabled\n  -DEXPERIMENTAL=true|false  Enable/disable access to peer in robot interfaces\n  -DPARALLEL=true|false      Enable/disable parallel processing of robots turns\n  -DRANDOMSEED=<long number> Set seed for deterministic behavior of random\n                             numbers\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResultsData(BattleCompletedEvent event) {
        if (this.setup.resultsFilename == null && (!this.setup.exitOnComplete || this.windowManager.isGUIEnabled())) {
            return;
        }
        PrintStream out = null;
        FileOutputStream fos = null;
        try {
            if (this.setup.resultsFilename == null) {
                out = Logger.realOut;
            } else {
                File f = new File(this.setup.resultsFilename);
                try {
                    fos = new FileOutputStream(f);
                    out = new PrintStream(fos);
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e);
                }
            }
            if (out != null) {
                BattleResultsTableModel resultsTable = new BattleResultsTableModel(event.getSortedResults(), event.getBattleRules().getNumRounds());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                resultsTable.print(new PrintStream(baos));
                out.append(StringUtil.toBasicLatin((CharSequence)baos.toString()));
            }
        }
        catch (Throwable throwable) {
            FileUtil.cleanupStream(out);
            FileUtil.cleanupStream(fos);
            throw throwable;
        }
        FileUtil.cleanupStream((Object)out);
        FileUtil.cleanupStream(fos);
    }

    @Override
    public void cleanup() {
        IWindowManager windowManager = Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.cleanup();
        }
        Container.getComponent(IBattleManager.class).cleanup();
        Container.getComponent(IHostManager.class).cleanup();
    }

    @Override
    public void initForRobocodeEngine(IBattleListener listener) {
        IWindowManager windowManager = Container.getComponent(IWindowManager.class);
        if (windowManager != null) {
            windowManager.setSlave(true);
            windowManager.setEnableGUI(false);
        }
        Container.getComponent(IHostManager.class).initSecurity();
        if (listener != null) {
            Container.getComponent(IBattleManager.class).addListener(listener);
        }
        Container.getComponent(ICpuManager.class).getCpuConstant();
        Container.getComponent(IRepositoryManager.class).reload(this.versionManager.isLastRunVersionChanged());
    }

    private class BattleObserver
    extends BattleAdaptor {
        boolean isReplay;

        private BattleObserver() {
        }

        public void onBattleStarted(BattleStartedEvent event) {
            this.isReplay = event.isReplay();
        }

        public void onBattleCompleted(BattleCompletedEvent event) {
            if (!this.isReplay) {
                RobocodeMain.this.printResultsData(event);
            }
            if (((RobocodeMain)RobocodeMain.this).setup.recordFilename != null) {
                RobocodeMain.this.recordManager.saveRecord(((RobocodeMain)RobocodeMain.this).setup.recordFilename, BattleRecordFormat.BINARY_ZIP, new SerializableOptions(false));
            }
            if (((RobocodeMain)RobocodeMain.this).setup.recordXmlFilename != null) {
                RobocodeMain.this.recordManager.saveRecord(((RobocodeMain)RobocodeMain.this).setup.recordXmlFilename, BattleRecordFormat.XML, new SerializableOptions(false));
            }
        }

        public void onBattleMessage(BattleMessageEvent event) {
            if (System.getProperty("logMessages", "true").equalsIgnoreCase("true")) {
                Logger.realOut.println(event.getMessage());
            }
        }

        public void onBattleError(BattleErrorEvent event) {
            if (System.getProperty("logErrors", "true").equalsIgnoreCase("true")) {
                Logger.realErr.println(event.getError());
            }
        }
    }

    private static class Setup {
        boolean minimize;
        boolean exitOnComplete;
        String battleFilename;
        String recordFilename;
        String recordXmlFilename;
        String replayFilename;
        String resultsFilename;
        int tps;

        private Setup() {
        }
    }
}

