/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class CodeSizeCalculator {
    public static Integer getDirectoryCodeSize(File dir) {
        return CodeSizeCalculator.getCodeSize("processDirectory", dir);
    }

    public static Integer getJarFileCodeSize(File jarFile) {
        return CodeSizeCalculator.getCodeSize("processZipFile", jarFile);
    }

    private static Integer getCodeSize(String invokeMethod, File jarFile) {
        Integer codesize;
        try {
            Class<?> classType = Class.forName("codesize.Codesize");
            Method method = classType.getMethod(invokeMethod, File.class);
            Object item = method.invoke(null, jarFile);
            method = item.getClass().getMethod("getCodeSize", null);
            codesize = (Integer)method.invoke(item, (Object[])null);
        }
        catch (IllegalAccessException e) {
            codesize = null;
        }
        catch (InvocationTargetException e) {
            codesize = null;
        }
        catch (NoSuchMethodException e) {
            codesize = null;
        }
        catch (ClassNotFoundException e) {
            codesize = null;
        }
        return codesize;
    }
}

