/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.io;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import net.sf.robocode.io.Logger;

public class URLJarCollector {
    private static HashMap<?, ?> fileCache;
    private static HashMap<?, ?> urlCache;
    private static Field jarFileURL;
    private static final boolean sunJVM;
    private static boolean enabled;
    private static final Set<URL> urlsToClean;

    public static synchronized URLConnection openConnection(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (sunJVM) {
            URLJarCollector.registerConnection(urlConnection);
            urlConnection.setUseCaches(true);
        } else {
            urlConnection.setUseCaches(false);
        }
        return urlConnection;
    }

    public static synchronized void enableGc(boolean enabled) {
        URLJarCollector.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void gc() {
        if (sunJVM) {
            if (enabled) {
                Set<URL> set = urlsToClean;
                synchronized (set) {
                    for (URL url : urlsToClean) {
                        URLJarCollector.closeJarURLConnection(url);
                    }
                    urlsToClean.clear();
                }
            }
            Iterator<?> it = fileCache.keySet().iterator();
            while (it.hasNext()) {
                Object urlJarFile = it.next();
                JarFile jarFile = (JarFile)fileCache.get(urlJarFile);
                String filename = jarFile.getName();
                if (!(filename = filename.substring(filename.lastIndexOf(File.separatorChar) + 1).toLowerCase()).startsWith("jar_cache")) continue;
                it.remove();
                HashMap<?, ?> hashMap = urlCache;
                synchronized (hashMap) {
                    urlCache.remove(jarFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerConnection(URLConnection conn) {
        block6: {
            String cl;
            if (conn != null && (cl = conn.getClass().getName()).equals("sun.net.www.protocol.jar.JarURLConnection")) {
                try {
                    URL url = (URL)jarFileURL.get(conn);
                    if (urlsToClean.contains(url)) break block6;
                    Set<URL> set = urlsToClean;
                    synchronized (set) {
                        urlsToClean.add(url);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void closeJarURLConnection(URL url) {
        if (url != null) {
            Iterator<?> it = fileCache.keySet().iterator();
            while (it.hasNext()) {
                Object urlJarFile = it.next();
                JarFile jarFile = (JarFile)fileCache.get(urlJarFile);
                String urlPath = url.getPath();
                try {
                    urlPath = URLDecoder.decode(urlPath, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                File urlFile = new File(urlPath);
                String jarFileName = jarFile.getName();
                String urlFileName = urlFile.getPath();
                if (!urlFileName.equals(jarFileName)) continue;
                it.remove();
                HashMap<?, ?> hashMap = urlCache;
                synchronized (hashMap) {
                    urlCache.remove(jarFile);
                }
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e);
                }
            }
        }
    }

    static {
        boolean localSunJVM = false;
        try {
            Class<?> jarFactory = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.jar.JarFileFactory");
            Field fileCacheF = jarFactory.getDeclaredField("fileCache");
            fileCacheF.setAccessible(true);
            fileCache = (HashMap)fileCacheF.get(null);
            Field urlCacheF = jarFactory.getDeclaredField("urlCache");
            urlCacheF.setAccessible(true);
            urlCache = (HashMap)urlCacheF.get(null);
            Class<?> jarURLConnection = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.jar.JarURLConnection");
            jarFileURL = jarURLConnection.getDeclaredField("jarFileURL");
            jarFileURL.setAccessible(true);
            localSunJVM = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        sunJVM = localSunJVM;
        urlsToClean = Collections.newSetFromMap(new WeakHashMap());
    }
}

