/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.peer;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.IXmlSerializable;
import net.sf.robocode.serialization.RbSerializer;
import net.sf.robocode.serialization.SerializableOptions;
import net.sf.robocode.serialization.XmlReader;
import net.sf.robocode.serialization.XmlWriter;
import robocode.control.snapshot.IDebugProperty;

public class DebugProperty
implements Serializable,
IXmlSerializable,
IDebugProperty {
    private static final long serialVersionUID = 1L;
    private String key;
    private String value;

    public DebugProperty() {
    }

    public DebugProperty(String key, String value) {
        this.setKey(key);
        this.setValue(value);
    }

    @Override
    public void writeXml(XmlWriter writer, SerializableOptions options) throws IOException {
        writer.startElement("debug");
        writer.writeAttribute("key", this.getKey());
        writer.writeAttribute("value", this.getValue());
        writer.endElement();
    }

    @Override
    public XmlReader.Element readXml(XmlReader reader) {
        return reader.expect("debug", new XmlReader.Element(){

            @Override
            public IXmlSerializable read(XmlReader reader) {
                final DebugProperty snapshot = new DebugProperty();
                reader.expect("key", new XmlReader.Attribute(){

                    @Override
                    public void read(String value) {
                        snapshot.setKey(value);
                    }
                });
                reader.expect("value", new XmlReader.Attribute(){

                    @Override
                    public void read(String value) {
                        snapshot.setValue(value);
                    }
                });
                return snapshot;
            }
        });
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            DebugProperty obj = (DebugProperty)object;
            return 1 + serializer.sizeOf(obj.key) + serializer.sizeOf(obj.value);
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            DebugProperty obj = (DebugProperty)object;
            serializer.serialize(buffer, obj.key);
            serializer.serialize(buffer, obj.value);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            String key = serializer.deserializeString(buffer);
            String value = serializer.deserializeString(buffer);
            return new DebugProperty(key, value);
        }
    }
}

