/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.repository;

import java.io.Serializable;

public final class RobotType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient int NONE_FLAG = 0;
    private static final transient int JUNIOR_FLAG = 1;
    private static final transient int STANDARD_FLAG = 2;
    private static final transient int ADVANCED_FLAG = 4;
    private static final transient int TEAM_FLAG = 8;
    private static final transient int DROID_FLAG = 16;
    private static final transient int INTERACTIVE_FLAG = 32;
    private static final transient int PAINTING_FLAG = 64;
    private static final transient int SENTRY_FLAG = 128;
    public static final transient RobotType INVALID = new RobotType(0);
    private int typeFlags;

    private RobotType(int typeFlags) {
        this.typeFlags = typeFlags;
    }

    public RobotType(boolean isJuniorRobot, boolean isStandardRobot, boolean isInteractiveRobot, boolean isPaintRobot, boolean isAdvancedRobot, boolean isTeamRobot, boolean isDroid, boolean isSentryRobot) {
        this.typeFlags = 0;
        if (isJuniorRobot) {
            this.typeFlags |= 1;
        }
        if (isStandardRobot) {
            this.typeFlags |= 2;
        }
        if (isInteractiveRobot) {
            this.typeFlags |= 0x20;
        }
        if (isPaintRobot) {
            this.typeFlags |= 0x40;
        }
        if (isAdvancedRobot) {
            this.typeFlags |= 4;
        }
        if (isTeamRobot) {
            this.typeFlags |= 8;
        }
        if (isDroid) {
            this.typeFlags |= 0x10;
        }
        if (isSentryRobot) {
            this.typeFlags |= 0x80;
        }
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }

    public boolean isValid() {
        return this.isJuniorRobot() || this.isStandardRobot() || this.isAdvancedRobot();
    }

    public boolean isJuniorRobot() {
        return (this.typeFlags & 1) != 0;
    }

    public boolean isStandardRobot() {
        return (this.typeFlags & 2) != 0;
    }

    public boolean isInteractiveRobot() {
        return (this.typeFlags & 0x20) != 0;
    }

    public boolean isPaintRobot() {
        return (this.typeFlags & 0x40) != 0;
    }

    public boolean isAdvancedRobot() {
        return (this.typeFlags & 4) != 0;
    }

    public boolean isTeamRobot() {
        return (this.typeFlags & 8) != 0;
    }

    public boolean isDroid() {
        return (this.typeFlags & 0x10) != 0;
    }

    public boolean isSentryRobot() {
        return (this.typeFlags & 0x80) != 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.typeFlags;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RobotType other = (RobotType)obj;
        return this.typeFlags == other.typeFlags;
    }
}

