/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.version;

public class Version
implements Comparable<Object> {
    private final String version;
    private final int major;
    private final int minor;
    private final int revision;
    private final int build;
    private final int maturity;
    private final int maturity_version;

    public Version(String version) {
        int maturity;
        if (!version.matches("\\s*[0-9]+\\.[0-9]+(\\.[0-9]+)?(\\.[0-9]+)?(\\s?(([aA]lpha)|([bB]eta))(\\s?[0-9]+)?)?\\s*")) {
            throw new IllegalArgumentException("The format of the version string is not a valid");
        }
        this.version = version = version.trim();
        String[] numbers = version.split("\\.");
        int major = 0;
        if (numbers.length >= 1) {
            try {
                major = Integer.parseInt(numbers[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.major = major;
        int minor = 0;
        if (numbers.length >= 2) {
            try {
                String[] split = numbers[1].split("\\s++|([aA]lpha)|([bB]eta)");
                minor = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException split) {
                // empty catch block
            }
        }
        this.minor = minor;
        int revision = 0;
        if (numbers.length >= 3) {
            try {
                String[] split = numbers[2].split("\\s++|([aA]lpha)|([bB]eta)");
                revision = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException split) {
                // empty catch block
            }
        }
        this.revision = revision;
        int build = 0;
        if (numbers.length >= 4) {
            try {
                String[] split = numbers[3].split("\\s++|([aA]lpha)|([bB]eta)");
                build = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException split) {
                // empty catch block
            }
        }
        this.build = build;
        int maturity_version = 1;
        if (this.isAlpha()) {
            maturity = 1;
            String[] split = version.split("[aA]lpha");
            if (split.length >= 2) {
                maturity_version = Integer.parseInt(split[1].trim());
            }
        } else if (this.isBeta()) {
            maturity = 2;
            String[] split = version.split("[bB]eta");
            if (split.length >= 2) {
                maturity_version = Integer.parseInt(split[1].trim());
            }
        } else {
            maturity = 3;
        }
        this.maturity = maturity;
        this.maturity_version = maturity_version;
    }

    public boolean isAlpha() {
        return this.version.matches(".*[aA]lpha.*");
    }

    public boolean isBeta() {
        return this.version.matches(".*[bB]eta.*");
    }

    public boolean isFinal() {
        return !this.isAlpha() && !this.isBeta();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getBuild() {
        return this.build;
    }

    public String toString() {
        return this.version;
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("The input object cannot be null");
        }
        if (o instanceof String) {
            return this.compareTo(new Version((String)o));
        }
        if (o instanceof Version) {
            Version v = (Version)o;
            long delta = this.getVersionLong() - v.getVersionLong();
            return delta == 0L ? 0 : (delta < 0L ? -1 : 1);
        }
        throw new IllegalArgumentException("The input object must be a String or Version object");
    }

    private long getVersionLong() {
        return ((long)this.major << 40) + ((long)this.minor << 32) + (long)(this.revision << 24) + (long)(this.build << 16) + (long)(this.maturity << 8) + (long)this.maturity_version;
    }

    public static int compare(String oneVersion, String anotherVersion) {
        return new Version(oneVersion).compareTo(new Version(anotherVersion));
    }

    public static boolean isBeta(String version) {
        return new Version(version).isBeta();
    }

    public static boolean isFinal(String version) {
        return new Version(version).isFinal();
    }
}

