/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.events;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.robocode.host.events.EventQueue;
import net.sf.robocode.host.events.IEventManager;
import net.sf.robocode.host.proxies.BasicRobotProxy;
import net.sf.robocode.io.Logger;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.security.HiddenAccess;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.KeyPressedEvent;
import robocode.KeyReleasedEvent;
import robocode.KeyTypedEvent;
import robocode.MessageEvent;
import robocode.MouseClickedEvent;
import robocode.MouseDraggedEvent;
import robocode.MouseEnteredEvent;
import robocode.MouseExitedEvent;
import robocode.MouseMovedEvent;
import robocode.MousePressedEvent;
import robocode.MouseReleasedEvent;
import robocode.MouseWheelMovedEvent;
import robocode.PaintEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.exception.EventInterruptedException;
import robocode.robotinterfaces.IBasicRobot;

public final class EventManager
implements IEventManager {
    private static final int MAX_PRIORITY = 100;
    public static final int MAX_EVENT_STACK = 2;
    public static final int MAX_QUEUE_SIZE = 256;
    private final List<Condition> customEvents = new CopyOnWriteArrayList<Condition>();
    private final EventQueue eventQueue;
    private final boolean[] interruptible = new boolean[101];
    private Event currentTopEvent;
    private int currentTopEventPriority;
    private ScannedRobotEvent dummyScannedRobotEvent;
    private Map<String, Event> eventNames;
    private IBasicRobot robot;
    private BasicRobotProxy robotProxy;

    public EventManager(BasicRobotProxy robotProxy) {
        this.robotProxy = robotProxy;
        this.eventQueue = new EventQueue();
        this.registerEventNames();
        this.reset();
    }

    public void add(Event event) {
        if (!HiddenAccess.isCriticalEvent((Event)event)) {
            int priority = this.getEventPriority(event.getClass().getName());
            HiddenAccess.setEventPriority((Event)event, (int)priority);
        }
        this.addImpl(event);
    }

    private void addImpl(Event event) {
        if (this.eventQueue != null) {
            if (this.eventQueue.size() > 256) {
                this.robotProxy.println("Not adding to " + this.robotProxy.getStatics().getName() + "'s queue, exceeded " + 256 + " events in queue.");
            } else {
                HiddenAccess.setEventTime((Event)event, (long)this.getTime());
                this.eventQueue.add(event);
            }
        }
    }

    @Override
    public void addCustomEvent(Condition condition) {
        this.customEvents.add(condition);
    }

    @Override
    public void clearAllEvents(boolean includingSystemEvents) {
        this.eventQueue.clear(includingSystemEvents);
    }

    public void cleanup() {
        this.reset();
        this.robot = null;
        this.robotProxy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> getAllEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                events.add(e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BulletHitBulletEvent> getBulletHitBulletEvents() {
        ArrayList<BulletHitBulletEvent> events = new ArrayList<BulletHitBulletEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof BulletHitBulletEvent)) continue;
                events.add((BulletHitBulletEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BulletHitEvent> getBulletHitEvents() {
        ArrayList<BulletHitEvent> events = new ArrayList<BulletHitEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof BulletHitEvent)) continue;
                events.add((BulletHitEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BulletMissedEvent> getBulletMissedEvents() {
        ArrayList<BulletMissedEvent> events = new ArrayList<BulletMissedEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof BulletMissedEvent)) continue;
                events.add((BulletMissedEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HitByBulletEvent> getHitByBulletEvents() {
        ArrayList<HitByBulletEvent> events = new ArrayList<HitByBulletEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof HitByBulletEvent)) continue;
                events.add((HitByBulletEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HitRobotEvent> getHitRobotEvents() {
        ArrayList<HitRobotEvent> events = new ArrayList<HitRobotEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof HitRobotEvent)) continue;
                events.add((HitRobotEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HitWallEvent> getHitWallEvents() {
        ArrayList<HitWallEvent> events = new ArrayList<HitWallEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof HitWallEvent)) continue;
                events.add((HitWallEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RobotDeathEvent> getRobotDeathEvents() {
        ArrayList<RobotDeathEvent> events = new ArrayList<RobotDeathEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof RobotDeathEvent)) continue;
                events.add((RobotDeathEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScannedRobotEvent> getScannedRobotEvents() {
        ArrayList<ScannedRobotEvent> events = new ArrayList<ScannedRobotEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof ScannedRobotEvent)) continue;
                events.add((ScannedRobotEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageEvent> getMessageEvents() {
        ArrayList<MessageEvent> events = new ArrayList<MessageEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof MessageEvent)) continue;
                events.add((MessageEvent)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StatusEvent> getStatusEvents() {
        ArrayList<StatusEvent> events = new ArrayList<StatusEvent>();
        EventQueue eventQueue = this.eventQueue;
        synchronized (eventQueue) {
            for (Event e : this.eventQueue) {
                if (!(e instanceof StatusEvent)) continue;
                events.add((StatusEvent)e);
            }
        }
        return events;
    }

    public int getCurrentTopEventPriority() {
        return this.currentTopEventPriority;
    }

    public Event getCurrentTopEvent() {
        return this.currentTopEvent;
    }

    public boolean isInterruptible(int priority) {
        return this.interruptible[priority];
    }

    public void setRobot(IBasicRobot robot) {
        this.robot = robot;
    }

    public int getScannedRobotEventPriority() {
        return this.dummyScannedRobotEvent.getPriority();
    }

    public long getTime() {
        return this.robotProxy.getTimeImpl();
    }

    public void processEvents() {
        Event currentEvent;
        this.eventQueue.clear(this.getTime() - 2L);
        for (Condition customEvent : this.customEvents) {
            boolean conditionSatisfied = this.callUserCode(customEvent);
            if (!conditionSatisfied) continue;
            this.addImpl((Event)new CustomEvent(customEvent));
        }
        this.eventQueue.sort();
        while ((currentEvent = this.eventQueue.size() > 0 ? (Event)this.eventQueue.get(0) : null) != null && currentEvent.getPriority() >= this.currentTopEventPriority) {
            if (currentEvent.getPriority() == this.currentTopEventPriority) {
                if (this.currentTopEventPriority <= Integer.MIN_VALUE || !this.isInterruptible(this.currentTopEventPriority)) break;
                this.setInterruptible(this.currentTopEventPriority, false);
                throw new EventInterruptedException(currentEvent.getPriority());
            }
            int oldTopEventPriority = this.currentTopEventPriority;
            this.currentTopEventPriority = currentEvent.getPriority();
            this.currentTopEvent = currentEvent;
            this.eventQueue.remove(currentEvent);
            try {
                this.dispatch(currentEvent);
                this.setInterruptible(this.currentTopEventPriority, false);
            }
            catch (EventInterruptedException e) {
                this.currentTopEvent = null;
            }
            catch (RuntimeException e) {
                this.currentTopEvent = null;
                throw e;
            }
            catch (Error e) {
                this.currentTopEvent = null;
                throw e;
            }
            finally {
                this.currentTopEventPriority = oldTopEventPriority;
            }
        }
    }

    private boolean callUserCode(Condition condition) {
        boolean conditionSatisfied;
        this.robotProxy.setTestingCondition(true);
        try {
            conditionSatisfied = condition.test();
        }
        finally {
            this.robotProxy.setTestingCondition(false);
        }
        return conditionSatisfied;
    }

    private void dispatch(Event event) {
        if (this.robot != null && event != null) {
            try {
                if (event.getTime() > this.getTime() - 2L || HiddenAccess.isCriticalEvent((Event)event)) {
                    HiddenAccess.dispatch((Event)event, (IBasicRobot)this.robot, (IRobotStatics)this.robotProxy.getStatics(), (Graphics2D)this.robotProxy.getGraphicsImpl());
                }
            }
            catch (Exception ex) {
                this.robotProxy.println("SYSTEM: " + ex.getClass().getName() + " occurred on " + event.getClass().getName());
                if (this.robotProxy.getRobotSpecification().isDevelopmentVersion()) {
                    Logger.logWarning((String)(this.robotProxy.getName() + ": " + ex.getClass().getName() + " occurred on " + event.getClass().getName()));
                }
                ex.printStackTrace(this.robotProxy.getOut());
            }
        }
    }

    @Override
    public void removeCustomEvent(Condition condition) {
        this.customEvents.remove(condition);
    }

    public void resetCustomEvents() {
        this.customEvents.clear();
    }

    public synchronized void reset() {
        this.currentTopEventPriority = Integer.MIN_VALUE;
        this.clearAllEvents(true);
        this.customEvents.clear();
    }

    public void setInterruptible(int priority, boolean isInterruptable) {
        if (priority >= 0 && priority < 100) {
            this.interruptible[priority] = isInterruptable;
        }
    }

    @Override
    public int getEventPriority(String eventClass) {
        if (eventClass == null) {
            return -1;
        }
        Event event = this.eventNames.get(eventClass);
        if (event == null) {
            return -1;
        }
        return event.getPriority();
    }

    @Override
    public void setEventPriority(String eventClass, int priority) {
        if (eventClass == null) {
            return;
        }
        Event event = this.eventNames.get(eventClass);
        if (event == null) {
            this.robotProxy.println("SYSTEM: Unknown event class: " + eventClass);
            return;
        }
        if (HiddenAccess.isCriticalEvent((Event)event)) {
            this.robotProxy.println("SYSTEM: You may not change the priority of a system event.");
        }
        HiddenAccess.setEventPriority((Event)event, (int)priority);
    }

    private void registerEventNames() {
        this.eventNames = new HashMap<String, Event>();
        this.dummyScannedRobotEvent = new ScannedRobotEvent(null, 0.0, 0.0, 0.0, 0.0, 0.0, false);
        this.registerEventNames((Event)new BattleEndedEvent(false, null));
        this.registerEventNames((Event)new BulletHitBulletEvent(null, null));
        this.registerEventNames((Event)new BulletHitEvent(null, 0.0, null));
        this.registerEventNames((Event)new BulletMissedEvent(null));
        this.registerEventNames((Event)new DeathEvent());
        this.registerEventNames((Event)new HitByBulletEvent(0.0, null));
        this.registerEventNames((Event)new HitRobotEvent(null, 0.0, 0.0, false));
        this.registerEventNames((Event)new HitWallEvent(0.0));
        this.registerEventNames((Event)new KeyPressedEvent(null));
        this.registerEventNames((Event)new KeyReleasedEvent(null));
        this.registerEventNames((Event)new KeyTypedEvent(null));
        this.registerEventNames((Event)new MessageEvent(null, null));
        this.registerEventNames((Event)new MouseClickedEvent(null));
        this.registerEventNames((Event)new MouseDraggedEvent(null));
        this.registerEventNames((Event)new MouseEnteredEvent(null));
        this.registerEventNames((Event)new MouseExitedEvent(null));
        this.registerEventNames((Event)new MouseMovedEvent(null));
        this.registerEventNames((Event)new MousePressedEvent(null));
        this.registerEventNames((Event)new MouseReleasedEvent(null));
        this.registerEventNames((Event)new MouseWheelMovedEvent(null));
        this.registerEventNames((Event)new PaintEvent());
        this.registerEventNames((Event)new RobotDeathEvent(null));
        this.registerEventNames((Event)new RoundEndedEvent(0, 0, 0));
        this.registerEventNames((Event)this.dummyScannedRobotEvent);
        this.registerEventNames((Event)new SkippedTurnEvent(0L));
        this.registerEventNames((Event)new StatusEvent(null));
        this.registerEventNames((Event)new WinEvent());
        DummyCustomEvent customEvent = new DummyCustomEvent();
        this.eventNames.put("robocode.CustomEvent", (Event)customEvent);
        this.eventNames.put("CustomEvent", (Event)customEvent);
    }

    private void registerEventNames(Event event) {
        if (!HiddenAccess.isCriticalEvent((Event)event)) {
            HiddenAccess.setDefaultPriority((Event)event);
        }
        Class<?> type = event.getClass();
        this.eventNames.put(type.getName(), event);
        this.eventNames.put(type.getSimpleName(), event);
    }

    private static final class DummyCustomEvent
    extends CustomEvent {
        public DummyCustomEvent() {
            super(null);
        }
    }
}

