/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.io;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.robocode.host.io.BufferedPipedOutputStream;
import net.sf.robocode.io.RobocodeProperties;

public class RobotOutputStream
extends PrintStream {
    private static final int MAX_CHARS = 50000;
    private int count = 0;
    private boolean messaged = false;
    private final StringBuilder text;
    private final Object syncRoot = new Object();

    public RobotOutputStream() {
        super(new BufferedPipedOutputStream(128, true));
        this.text = new StringBuilder(8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAndReset() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.count = 0;
            if (this.text.length() > 0) {
                String result = this.text.toString();
                this.text.setLength(0);
                return result;
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOkToPrint() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (RobocodeProperties.isDebuggingOn()) {
                return true;
            }
            if (this.count > 50000) {
                if (!this.messaged) {
                    this.text.append("\nSYSTEM: This robot is printing too much between actions.  Output stopped until next action.\n");
                    this.messaged = true;
                }
                return false;
            }
            this.messaged = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(char[] s) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append(s);
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(char c) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                this.text.append(c);
                ++this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(double d) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append(d);
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(float f) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append(f);
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(int i) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append(i);
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(long l) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append(l);
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Object obj) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                if (obj != null) {
                    String s = obj.toString();
                    this.text.append(s);
                } else {
                    this.text.append((Object)null);
                }
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String s) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append(s);
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(boolean b) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append(b);
                this.count += this.text.length() - origLen;
            }
        }
    }

    @Override
    public void println() {
        this.print('\n');
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.print('\n');
    }

    @Override
    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint() && buf != null) {
                int origLen = this.text.length();
                for (int i = 0; i < len; ++i) {
                    this.text.append((char)buf[off + i]);
                }
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.isOkToPrint()) {
                int origLen = this.text.length();
                this.text.append((char)b);
                this.count += this.text.length() - origLen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable t) {
        if (t != null) {
            Object object = this.syncRoot;
            synchronized (object) {
                if (this.isOkToPrint()) {
                    StringWriter sw = new StringWriter();
                    PrintWriter writer = new PrintWriter(sw);
                    t.printStackTrace(writer);
                    writer.flush();
                    int origLen = this.text.length();
                    this.text.append(sw.toString());
                    this.count += this.text.length() - origLen;
                }
            }
        }
    }
}

