/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.proxies;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.events.EventManager;
import net.sf.robocode.host.proxies.HostingRobotProxy;
import net.sf.robocode.peer.BulletCommand;
import net.sf.robocode.peer.BulletStatus;
import net.sf.robocode.peer.ExecCommands;
import net.sf.robocode.peer.ExecResults;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.peer.TeamMessage;
import net.sf.robocode.repository.IRobotItem;
import net.sf.robocode.robotpaint.Graphics2DSerialized;
import net.sf.robocode.robotpaint.IGraphicsProxy;
import net.sf.robocode.security.HiddenAccess;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.Condition;
import robocode.Event;
import robocode.PaintEvent;
import robocode.RobotStatus;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.exception.AbortedException;
import robocode.exception.DeathException;
import robocode.exception.DisabledException;
import robocode.exception.RobotException;
import robocode.exception.WinException;
import robocode.robotinterfaces.peer.IBasicRobotPeer;
import robocode.util.Utils;

public class BasicRobotProxy
extends HostingRobotProxy
implements IBasicRobotPeer {
    private static final long MAX_SET_CALL_COUNT = 10000L;
    private static final long MAX_GET_CALL_COUNT = 10000L;
    private IGraphicsProxy graphicsProxy;
    private RobotStatus status;
    private boolean isDisabled;
    protected ExecCommands commands;
    private ExecResults execResults;
    private final Map<Integer, Bullet> bullets = new ConcurrentHashMap<Integer, Bullet>();
    private int nextBulletId = 1;
    private final AtomicInteger setCallCount = new AtomicInteger(0);
    private final AtomicInteger getCallCount = new AtomicInteger(0);
    protected Condition waitCondition;
    private boolean testingCondition;
    private double firedEnergy;
    private double firedHeat;

    BasicRobotProxy(IRobotItem specification, IHostManager hostManager, IRobotPeer peer, RobotStatics statics) {
        super(specification, hostManager, peer, statics);
        this.eventManager = new EventManager(this);
        this.graphicsProxy = new Graphics2DSerialized();
        this.execResults = new ExecResults(null, null, null, null, null, false, false, false);
        this.setSetCallCount(0);
        this.setGetCallCount(0);
    }

    @Override
    protected void initializeRound(ExecCommands commands, RobotStatus status) {
        this.updateStatus(commands, status);
        this.eventManager.reset();
        this.eventManager.add((Event)new StatusEvent(status));
        this.setSetCallCount(0);
        this.setGetCallCount(0);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.waitCondition != null) {
            this.waitCondition.cleanup();
            this.waitCondition = null;
        }
        if (this.eventManager != null) {
            this.eventManager.cleanup();
            this.eventManager = null;
        }
        this.graphicsProxy = null;
        this.execResults = null;
        this.status = null;
        this.commands = null;
    }

    public Bullet setFire(double power) {
        this.setCall();
        return this.setFireImpl(power);
    }

    public void execute() {
        this.executeImpl();
    }

    public void move(double distance) {
        this.setMoveImpl(distance);
        do {
            this.execute();
        } while (this.getDistanceRemaining() != 0.0);
    }

    public void turnBody(double radians) {
        this.setTurnBodyImpl(radians);
        do {
            this.execute();
        } while (this.getBodyTurnRemaining() != 0.0);
    }

    public void turnGun(double radians) {
        this.setTurnGunImpl(radians);
        do {
            this.execute();
        } while (this.getGunTurnRemaining() != 0.0);
    }

    public Bullet fire(double power) {
        Bullet bullet = this.setFire(power);
        this.execute();
        return bullet;
    }

    public void setBodyColor(Color color) {
        this.commands.setBodyColor(color != null ? color.getRGB() : -14079604);
    }

    public void setGunColor(Color color) {
        this.commands.setGunColor(color != null ? color.getRGB() : -14079604);
    }

    public void setRadarColor(Color color) {
        this.commands.setRadarColor(color != null ? color.getRGB() : -14079604);
    }

    public void setBulletColor(Color color) {
        this.commands.setBulletColor(color != null ? color.getRGB() : -1);
    }

    public void setScanColor(Color color) {
        this.commands.setScanColor(color != null ? color.getRGB() : -16776961);
    }

    public void setCall() {
        int res;
        if (!this.isDisabled && (long)(res = this.setCallCount.incrementAndGet()) >= 10000L) {
            this.isDisabled = true;
            this.println("SYSTEM: You have made " + res + " calls to setXX methods without calling execute()");
            throw new DisabledException("Too many calls to setXX methods");
        }
    }

    public void getCall() {
        int res;
        if (!this.isDisabled && (long)(res = this.getCallCount.incrementAndGet()) >= 10000L) {
            this.isDisabled = true;
            this.println("SYSTEM: You have made " + res + " calls to getXX methods without calling execute()");
            throw new DisabledException("Too many calls to getXX methods");
        }
    }

    public double getDistanceRemaining() {
        this.getCall();
        return this.commands.getDistanceRemaining();
    }

    public double getRadarTurnRemaining() {
        this.getCall();
        return this.commands.getRadarTurnRemaining();
    }

    public double getBodyTurnRemaining() {
        this.getCall();
        return this.commands.getBodyTurnRemaining();
    }

    public double getGunTurnRemaining() {
        this.getCall();
        return this.commands.getGunTurnRemaining();
    }

    public double getVelocity() {
        this.getCall();
        return this.status.getVelocity();
    }

    public double getGunCoolingRate() {
        this.getCall();
        return this.statics.getBattleRules().getGunCoolingRate();
    }

    public String getName() {
        this.getCall();
        return this.statics.getName();
    }

    public long getTime() {
        this.getCall();
        return this.getTimeImpl();
    }

    public double getBodyHeading() {
        this.getCall();
        return this.status.getHeadingRadians();
    }

    public double getGunHeading() {
        this.getCall();
        return this.status.getGunHeadingRadians();
    }

    public double getRadarHeading() {
        this.getCall();
        return this.status.getRadarHeadingRadians();
    }

    public double getEnergy() {
        this.getCall();
        return this.getEnergyImpl();
    }

    public double getGunHeat() {
        this.getCall();
        return this.getGunHeatImpl();
    }

    public double getX() {
        this.getCall();
        return this.status.getX();
    }

    public double getY() {
        this.getCall();
        return this.status.getY();
    }

    public int getOthers() {
        this.getCall();
        return this.status.getOthers();
    }

    public int getNumSentries() {
        this.getCall();
        return this.status.getNumSentries();
    }

    public double getBattleFieldHeight() {
        this.getCall();
        return this.statics.getBattleRules().getBattlefieldHeight();
    }

    public double getBattleFieldWidth() {
        this.getCall();
        return this.statics.getBattleRules().getBattlefieldWidth();
    }

    public int getNumRounds() {
        this.getCall();
        return this.statics.getBattleRules().getNumRounds();
    }

    public int getRoundNum() {
        this.getCall();
        return this.status.getRoundNum();
    }

    public int getSentryBorderSize() {
        this.getCall();
        return this.statics.getBattleRules().getSentryBorderSize();
    }

    public Graphics2D getGraphics() {
        this.getCall();
        this.commands.setTryingToPaint(true);
        return this.getGraphicsImpl();
    }

    public void setDebugProperty(String key, String value) {
        this.setCall();
        this.commands.setDebugProperty(key, value);
    }

    public void rescan() {
        boolean reset = false;
        boolean origInterruptableValue = false;
        if (this.eventManager.getCurrentTopEventPriority() == this.eventManager.getScannedRobotEventPriority()) {
            reset = true;
            origInterruptableValue = this.eventManager.isInterruptible(this.eventManager.getScannedRobotEventPriority());
            this.eventManager.setInterruptible(this.eventManager.getScannedRobotEventPriority(), true);
        }
        this.commands.setScan(true);
        this.executeImpl();
        if (reset) {
            this.eventManager.setInterruptible(this.eventManager.getScannedRobotEventPriority(), origInterruptableValue);
        }
    }

    public long getTimeImpl() {
        return this.status.getTime();
    }

    public Graphics2D getGraphicsImpl() {
        return (Graphics2D)this.graphicsProxy;
    }

    @Override
    protected final void executeImpl() {
        if (this.execResults == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.robotThreadManager.checkRunThread();
        if (this.testingCondition) {
            throw new RobotException("You cannot take action inside Condition.test().  You should handle onCustomEvent instead.");
        }
        this.setSetCallCount(0);
        this.setGetCallCount(0);
        if (this.waitCondition != null && this.waitCondition.test()) {
            this.waitCondition = null;
            this.commands.setScan(true);
        }
        this.commands.setOutputText(this.out.readAndReset());
        this.commands.setGraphicsCalls(this.graphicsProxy.readoutQueuedCalls());
        this.execResults = this.peer.executeImpl(this.commands);
        this.updateStatus(this.execResults.getCommands(), this.execResults.getStatus());
        this.graphicsProxy.setPaintingEnabled(this.execResults.isPaintEnabled());
        this.firedEnergy = 0.0;
        this.firedHeat = 0.0;
        this.eventManager.add((Event)new StatusEvent(this.execResults.getStatus()));
        if (this.statics.isPaintRobot() && this.execResults.isPaintEnabled()) {
            this.eventManager.add((Event)new PaintEvent());
        }
        if (this.execResults.getEvents() != null) {
            for (Event event : this.execResults.getEvents()) {
                this.eventManager.add(event);
            }
        }
        if (this.execResults.getBulletUpdates() != null) {
            for (BulletStatus bulletStatus : this.execResults.getBulletUpdates()) {
                Bullet bullet = this.bullets.get(bulletStatus.bulletId);
                if (bullet == null) continue;
                HiddenAccess.update((Bullet)bullet, (double)bulletStatus.x, (double)bulletStatus.y, (String)bulletStatus.victimName, (boolean)bulletStatus.isActive);
                if (bulletStatus.isActive) continue;
                this.bullets.remove(bulletStatus.bulletId);
            }
        }
        this.loadTeamMessages(this.execResults.getTeamMessages());
        this.eventManager.processEvents();
    }

    @Override
    protected final void waitForBattleEndImpl() {
        this.eventManager.clearAllEvents(false);
        this.graphicsProxy.setPaintingEnabled(false);
        do {
            try {
                this.eventManager.processEvents();
            }
            catch (DeathException deathException) {
            }
            catch (WinException winException) {
            }
            catch (AbortedException abortedException) {
            }
            catch (DisabledException disabledException) {
                // empty catch block
            }
            this.commands.setOutputText(this.out.readAndReset());
            this.commands.setGraphicsCalls(this.graphicsProxy.readoutQueuedCalls());
            this.execResults = this.peer.waitForBattleEndImpl(this.commands);
            this.updateStatus(this.execResults.getCommands(), this.execResults.getStatus());
            if (this.execResults.getEvents() != null) {
                for (Event event : this.execResults.getEvents()) {
                    if (!(event instanceof BattleEndedEvent)) continue;
                    this.eventManager.add(event);
                }
            }
            this.eventManager.resetCustomEvents();
        } while (!this.execResults.isHalt() && this.execResults.isShouldWait());
    }

    private void updateStatus(ExecCommands commands, RobotStatus status) {
        this.status = status;
        this.commands = commands;
    }

    protected void loadTeamMessages(List<TeamMessage> teamMessages) {
    }

    private final double getEnergyImpl() {
        return this.status.getEnergy() - this.firedEnergy;
    }

    private final double getGunHeatImpl() {
        return this.status.getGunHeat() + this.firedHeat;
    }

    protected final void setMoveImpl(double distance) {
        if (this.getEnergyImpl() == 0.0) {
            return;
        }
        this.commands.setDistanceRemaining(distance);
        this.commands.setMoved(true);
    }

    private final Bullet setFireImpl(double power) {
        BulletCommand wrapper;
        Bullet bullet;
        if (Double.isNaN(power)) {
            this.println("SYSTEM: You cannot call fire(NaN)");
            return null;
        }
        if (this.getGunHeatImpl() > 0.0 || this.getEnergyImpl() == 0.0) {
            return null;
        }
        power = Math.min(this.getEnergyImpl(), Math.min(Math.max(power, 0.1), 3.0));
        Event currentTopEvent = this.eventManager.getCurrentTopEvent();
        ++this.nextBulletId;
        if (currentTopEvent != null && currentTopEvent.getTime() == this.status.getTime() && !this.statics.isAdvancedRobot() && this.status.getGunHeadingRadians() == this.status.getRadarHeadingRadians() && ScannedRobotEvent.class.isAssignableFrom(currentTopEvent.getClass())) {
            ScannedRobotEvent e = (ScannedRobotEvent)currentTopEvent;
            double fireAssistAngle = Utils.normalAbsoluteAngle((double)(this.status.getHeadingRadians() + e.getBearingRadians()));
            bullet = new Bullet(fireAssistAngle, this.getX(), this.getY(), power, this.statics.getName(), null, true, this.nextBulletId);
            wrapper = new BulletCommand(power, true, fireAssistAngle, this.nextBulletId);
        } else {
            bullet = new Bullet(this.status.getGunHeadingRadians(), this.getX(), this.getY(), power, this.statics.getName(), null, true, this.nextBulletId);
            wrapper = new BulletCommand(power, false, 0.0, this.nextBulletId);
        }
        this.firedEnergy += power;
        this.firedHeat += Rules.getGunHeat((double)power);
        this.commands.getBullets().add(wrapper);
        this.bullets.put(this.nextBulletId, bullet);
        return bullet;
    }

    protected final void setTurnGunImpl(double radians) {
        this.commands.setGunTurnRemaining(radians);
    }

    protected final void setTurnBodyImpl(double radians) {
        if (this.getEnergyImpl() > 0.0) {
            this.commands.setBodyTurnRemaining(radians);
        }
    }

    protected final void setTurnRadarImpl(double radians) {
        this.commands.setRadarTurnRemaining(radians);
    }

    private void setSetCallCount(int setCallCount) {
        this.setCallCount.set(setCallCount);
    }

    private void setGetCallCount(int getCallCount) {
        this.getCallCount.set(getCallCount);
    }

    public void setTestingCondition(boolean testingCondition) {
        this.testingCondition = testingCondition;
    }

    public String toString() {
        return this.statics.getShortName() + "(" + (int)this.status.getEnergy() + ") X" + (int)this.status.getX() + " Y" + (int)this.status.getY();
    }
}

