/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.proxies;

import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.proxies.BasicRobotProxy;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.repository.IRobotItem;
import robocode.robotinterfaces.peer.IJuniorRobotPeer;

public class JuniorRobotProxy
extends BasicRobotProxy
implements IJuniorRobotPeer {
    public JuniorRobotProxy(IRobotItem specification, IHostManager hostManager, IRobotPeer peer, RobotStatics statics) {
        super(specification, hostManager, peer, statics);
    }

    public void turnAndMove(double distance, double radians) {
        if (distance == 0.0) {
            this.turnBody(radians);
            return;
        }
        double savedMaxVelocity = this.commands.getMaxVelocity();
        double savedMaxTurnRate = this.commands.getMaxTurnRate();
        double absDegrees = Math.abs(Math.toDegrees(radians));
        double absDistance = Math.abs(distance);
        double maxVelocity = Math.min(8.0, 10.0 / (absDegrees / absDistance + 0.75));
        double accDist = 0.0;
        double decDist = 0.0;
        int turns = 0;
        int t = 1;
        while ((double)t < maxVelocity) {
            accDist += (double)t;
            if (t > 2 && t % 2 > 0) {
                decDist += (double)(t - 2);
            }
            if (accDist + decDist >= absDistance) break;
            ++turns;
            if (t > 2 && t % 2 > 0) {
                ++turns;
            }
            ++t;
        }
        if (accDist + decDist < absDistance) {
            turns += (int)((absDistance - accDist - decDist) / maxVelocity + 1.0);
        }
        this.commands.setMaxVelocity(maxVelocity);
        this.setMoveImpl(distance);
        this.setTurnBodyImpl(radians);
        for (t = turns; t >= 0; --t) {
            this.commands.setMaxTurnRate(this.getVelocity() * radians / absDistance);
            this.execute();
        }
        this.commands.setMaxVelocity(savedMaxVelocity);
        this.commands.setMaxTurnRate(savedMaxTurnRate);
    }
}

