/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.proxies;

import java.io.File;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.proxies.StandardRobotProxy;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.repository.IRobotItem;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.robotinterfaces.peer.IAdvancedRobotPeer;

public class AdvancedRobotProxy
extends StandardRobotProxy
implements IAdvancedRobotPeer {
    public AdvancedRobotProxy(IRobotItem specification, IHostManager hostManager, IRobotPeer peer, RobotStatics statics) {
        super(specification, hostManager, peer, statics);
    }

    public boolean isAdjustGunForBodyTurn() {
        this.getCall();
        return this.commands.isAdjustGunForBodyTurn();
    }

    public boolean isAdjustRadarForGunTurn() {
        this.getCall();
        return this.commands.isAdjustRadarForGunTurn();
    }

    public boolean isAdjustRadarForBodyTurn() {
        this.getCall();
        return this.commands.isAdjustRadarForBodyTurn();
    }

    public void setResume() {
        this.setCall();
        this.setResumeImpl();
    }

    public void setStop(boolean overwrite) {
        this.setCall();
        this.setStopImpl(overwrite);
    }

    public void setMove(double distance) {
        this.setCall();
        this.setMoveImpl(distance);
    }

    public void setTurnBody(double radians) {
        this.setCall();
        this.setTurnBodyImpl(radians);
    }

    public void setTurnGun(double radians) {
        this.setCall();
        this.setTurnGunImpl(radians);
    }

    public void setTurnRadar(double radians) {
        this.setCall();
        this.setTurnRadarImpl(radians);
    }

    public void waitFor(Condition condition) {
        this.waitCondition = condition;
        do {
            this.execute();
        } while (!condition.test());
        this.waitCondition = null;
    }

    public void setMaxTurnRate(double newTurnRate) {
        this.setCall();
        if (Double.isNaN(newTurnRate)) {
            this.println("You cannot setMaxTurnRate to: " + newTurnRate);
            return;
        }
        this.commands.setMaxTurnRate(newTurnRate);
    }

    public void setMaxVelocity(double newVelocity) {
        this.setCall();
        if (Double.isNaN(newVelocity)) {
            this.println("You cannot setMaxVelocity to: " + newVelocity);
            return;
        }
        this.commands.setMaxVelocity(newVelocity);
    }

    public void setInterruptible(boolean interruptable) {
        this.setCall();
        this.eventManager.setInterruptible(this.eventManager.getCurrentTopEventPriority(), interruptable);
    }

    public void setEventPriority(String eventClass, int priority) {
        this.setCall();
        this.eventManager.setEventPriority(eventClass, priority);
    }

    public int getEventPriority(String eventClass) {
        this.getCall();
        return this.eventManager.getEventPriority(eventClass);
    }

    public void removeCustomEvent(Condition condition) {
        this.setCall();
        this.eventManager.removeCustomEvent(condition);
    }

    public void addCustomEvent(Condition condition) {
        this.setCall();
        this.eventManager.addCustomEvent(condition);
    }

    public void clearAllEvents() {
        this.setCall();
        this.eventManager.clearAllEvents(false);
    }

    public List<Event> getAllEvents() {
        this.getCall();
        return this.eventManager.getAllEvents();
    }

    public List<StatusEvent> getStatusEvents() {
        this.getCall();
        return this.eventManager.getStatusEvents();
    }

    public List<BulletMissedEvent> getBulletMissedEvents() {
        this.getCall();
        return this.eventManager.getBulletMissedEvents();
    }

    public List<BulletHitBulletEvent> getBulletHitBulletEvents() {
        this.getCall();
        return this.eventManager.getBulletHitBulletEvents();
    }

    public List<BulletHitEvent> getBulletHitEvents() {
        this.getCall();
        return this.eventManager.getBulletHitEvents();
    }

    public List<HitByBulletEvent> getHitByBulletEvents() {
        this.getCall();
        return this.eventManager.getHitByBulletEvents();
    }

    public List<HitRobotEvent> getHitRobotEvents() {
        this.getCall();
        return this.eventManager.getHitRobotEvents();
    }

    public List<HitWallEvent> getHitWallEvents() {
        this.getCall();
        return this.eventManager.getHitWallEvents();
    }

    public List<RobotDeathEvent> getRobotDeathEvents() {
        this.getCall();
        return this.eventManager.getRobotDeathEvents();
    }

    public List<ScannedRobotEvent> getScannedRobotEvents() {
        this.getCall();
        return this.eventManager.getScannedRobotEvents();
    }

    public File getDataDirectory() {
        this.getCall();
        this.commands.setIORobot();
        return this.robotFileSystemManager.getWritableDirectory();
    }

    public File getDataFile(final String filename) {
        this.getCall();
        this.commands.setIORobot();
        if (filename.contains("..")) {
            throw new AccessControlException("no relative path allowed");
        }
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                return AdvancedRobotProxy.this.robotFileSystemManager.getDataFile(filename);
            }
        });
    }

    public long getDataQuotaAvailable() {
        this.getCall();
        return this.robotFileSystemManager.getMaxQuota() - this.robotFileSystemManager.getQuotaUsed();
    }
}

