/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.robocode.io.Logger;
import robocode.robotinterfaces.IBasicRobot;

public final class ClassAnalyzer {
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private static final byte CONSTANT_MethodHandle = 15;
    private static final byte CONSTANT_MethodType = 16;
    private static final byte CONSTANT_InvokeDynamic = 18;

    static void getReferencedClasses(ByteBuffer classFile, Set<String> collection) {
        ClassInfo info;
        ArrayList<Integer> classNameIndexes = new ArrayList<Integer>();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(classFile.array(), 0, classFile.limit()));
            info = ClassAnalyzer.parseClassFile(classNameIndexes, in);
            if (info == null) {
                return;
            }
        }
        catch (IOException e) {
            return;
        }
        for (Integer classNameIndex : classNameIndexes) {
            String className = info.utf8s[classNameIndex].replace('\\', '.').replace('/', '.');
            if (className.indexOf("[") == 0 || collection.contains(className)) continue;
            collection.add(className);
        }
    }

    private static ClassInfo parseClassFile(List<Integer> classNameIndexes, DataInputStream in) throws IOException {
        long magic = in.readInt();
        if (magic != -889275714L) {
            Logger.logError((String)"Not a class file!");
            return null;
        }
        in.readUnsignedShort();
        in.readUnsignedShort();
        int constant_pool_count = in.readUnsignedShort();
        ClassInfo info = new ClassInfo(constant_pool_count);
        block10: for (int i = 1; i < constant_pool_count; ++i) {
            byte tag = in.readByte();
            switch (tag) {
                case 7: {
                    int name_index = in.readUnsignedShort();
                    classNameIndexes.add(name_index);
                    info.classNames[i] = name_index;
                    continue block10;
                }
                case 9: 
                case 10: 
                case 11: 
                case 18: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block10;
                }
                case 15: {
                    in.readUnsignedByte();
                    in.readUnsignedShort();
                    continue block10;
                }
                case 8: 
                case 16: {
                    in.readUnsignedShort();
                    continue block10;
                }
                case 3: 
                case 4: {
                    in.readInt();
                    continue block10;
                }
                case 5: 
                case 6: {
                    in.readInt();
                    in.readInt();
                    ++i;
                    continue block10;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block10;
                }
                case 1: {
                    String utf8_string;
                    info.utf8s[i] = utf8_string = in.readUTF();
                }
            }
        }
        return info;
    }

    public static final class RobotMainClassPredicate {
        private final HashMap<String, Boolean> cache = new HashMap();
        private final HashMap<String, Boolean> isConcrete = new HashMap();
        private final ByteBufferFunction fn;

        public RobotMainClassPredicate(ByteBufferFunction fn) {
            this.fn = fn;
        }

        private boolean calcAssignableToRobot(String binaryName) {
            if (binaryName.startsWith("robocode/")) {
                try {
                    return IBasicRobot.class.isAssignableFrom(Class.forName(binaryName.replace('/', '.').replace('$', '.')));
                }
                catch (ClassNotFoundException e) {
                    Logger.logError((String)e.toString());
                    return false;
                }
            }
            ByteBuffer classFile = this.fn.get(binaryName);
            if (classFile == null) {
                return false;
            }
            ArrayList classNameIndexes = new ArrayList();
            try {
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(classFile.array(), 0, classFile.limit()));
                ClassInfo info = ClassAnalyzer.parseClassFile(classNameIndexes, in);
                if (info == null) {
                    return false;
                }
                int access_flags = in.readUnsignedShort();
                this.isConcrete.put(binaryName, !((access_flags & 0x200) != 0 | (access_flags & 0x400) != 0));
                in.readUnsignedShort();
                int super_class = in.readUnsignedShort();
                int interfaces_count = in.readUnsignedShort();
                if (this.isAssignableToRobot(info.getClassName(super_class))) {
                    return true;
                }
                for (int i = 0; i < interfaces_count; ++i) {
                    int interface_index = in.readUnsignedShort();
                    if (!this.isAssignableToRobot(info.getClassName(interface_index))) continue;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        private boolean isAssignableToRobot(String binaryName) {
            if (binaryName == null) {
                return false;
            }
            if (binaryName.startsWith("java/")) {
                return false;
            }
            Boolean ret = this.cache.get(binaryName);
            if (ret != null) {
                return ret;
            }
            this.cache.put(binaryName, false);
            boolean res = this.calcAssignableToRobot(binaryName);
            this.cache.put(binaryName, res);
            return res;
        }

        public boolean isMainClassBinary(String binaryName) {
            if (this.isAssignableToRobot(binaryName)) {
                Boolean concrete = this.isConcrete.get(binaryName);
                if (concrete == null) {
                    return false;
                }
                return concrete;
            }
            return false;
        }

        public boolean isMainClass(String name) {
            return this.isMainClassBinary(name.replace('.', '/'));
        }
    }

    public static interface ByteBufferFunction {
        public ByteBuffer get(String var1);
    }

    private static final class ClassInfo {
        String[] utf8s;
        int[] classNames;

        ClassInfo(int constant_pool_count) {
            this.utf8s = new String[constant_pool_count];
            this.classNames = new int[constant_pool_count];
        }

        private String getClassName(int info_index) {
            return this.utf8s[this.classNames[info_index]];
        }
    }
}

