/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.Permission;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.io.RobocodeProperties;

public class RobocodeSecurityManager
extends SecurityManager {
    private final IThreadManager threadManager;

    public RobocodeSecurityManager(IThreadManager threadManager) {
        this.threadManager = threadManager;
        for (ThreadGroup tg = Thread.currentThread().getThreadGroup(); tg != null; tg = tg.getParent()) {
            threadManager.addSafeThreadGroup(tg);
        }
        this.isSafeThread(Thread.currentThread());
        if (RobocodeProperties.isSecurityOn()) {
            System.setSecurityManager(this);
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (RobocodeProperties.isSecurityOff()) {
            return;
        }
        Thread c = Thread.currentThread();
        if (this.isSafeThread(c)) {
            return;
        }
        super.checkAccess(t);
        boolean found = false;
        ThreadGroup cg = c.getThreadGroup();
        for (ThreadGroup tg = t.getThreadGroup(); tg != null; tg = tg.getParent()) {
            if (tg == cg) {
                found = true;
                break;
            }
            try {
                continue;
            }
            catch (AccessControlException e) {
                // empty catch block
                break;
            }
        }
        if (!found) {
            String message = "Preventing " + c.getName() + " from access to " + t.getName();
            IHostedThread robotProxy = this.threadManager.getLoadedOrLoadingRobotProxy(c);
            if (robotProxy != null) {
                robotProxy.punishSecurityViolation(message);
            }
            throw new SecurityException(message);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (RobocodeProperties.isSecurityOff()) {
            return;
        }
        Thread c = Thread.currentThread();
        if (this.isSafeThread(c)) {
            return;
        }
        super.checkAccess(g);
        ThreadGroup cg = c.getThreadGroup();
        if (cg == null) {
            return;
        }
        if ("SeedGenerator Thread".equals(c.getName()) && "SeedGenerator ThreadGroup".equals(cg.getName())) {
            return;
        }
        IHostedThread robotProxy = this.threadManager.getLoadedOrLoadingRobotProxy(c);
        if (robotProxy == null) {
            throw new AccessControlException("Preventing " + c.getName() + " from access to " + g.getName());
        }
        if (cg.activeCount() > 5) {
            String message = "Robots are only allowed to create up to 5 threads!";
            robotProxy.punishSecurityViolation(message);
            throw new SecurityException(message);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (RobocodeProperties.isSecurityOff()) {
            return;
        }
        Thread c = Thread.currentThread();
        if (this.isSafeThread(c)) {
            return;
        }
        super.checkPermission(perm);
        if (perm instanceof SocketPermission) {
            IHostedThread robotProxy = this.threadManager.getLoadedOrLoadingRobotProxy(c);
            String message = "Using socket is not allowed";
            robotProxy.punishSecurityViolation(message);
            throw new SecurityException(message);
        }
    }

    private boolean isSafeThread(Thread c) {
        return this.threadManager.isSafeThread(c);
    }
}

