/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.jarjar;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import net.sf.robocode.io.URLJarCollector;

public class JarJarURLConnection
extends URLConnection {
    private static final char SEPARATOR_CHAR = '^';
    private static final String SEPARATOR = "^/";
    private final URLConnection connection;
    private static boolean registered;

    private JarJarURLConnection(URL url) throws IOException {
        super(url);
        String file = url.getFile();
        URL inner = new URL(file);
        this.connection = URLJarCollector.openConnection((URL)inner);
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.connection.connect();
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.connection.getInputStream();
    }

    public static void register() {
        if (!registered) {
            URL.setURLStreamHandlerFactory(new JarJarURLStreamHandlerFactory());
            registered = true;
        }
    }

    private static class JarJarURLStreamHandler
    extends URLStreamHandler {
        private JarJarURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new JarJarURLConnection(u);
        }

        private int indexOfBangSlash(String spec) {
            int indexOfBang = spec.length();
            while ((indexOfBang = spec.lastIndexOf(94, indexOfBang)) != -1) {
                if (indexOfBang != spec.length() - 1 && spec.charAt(indexOfBang + 1) == '/') {
                    return indexOfBang + 1;
                }
                --indexOfBang;
            }
            return -1;
        }

        @Override
        protected void parseURL(URL url, String spec, int start, int limit) {
            boolean refOnly;
            String file = null;
            String ref = null;
            int refPos = spec.indexOf(35, limit);
            boolean bl = refOnly = refPos == start;
            if (refPos > -1) {
                ref = spec.substring(refPos + 1);
                if (refOnly) {
                    file = url.getFile();
                }
            }
            boolean absoluteSpec = false;
            if (spec.length() >= 7) {
                absoluteSpec = spec.substring(0, 7).equalsIgnoreCase("jarjar:");
            }
            spec = spec.substring(start, limit);
            if (absoluteSpec) {
                file = this.parseAbsoluteSpec(spec);
            } else if (!refOnly) {
                file = this.parseContextSpec(url, spec);
                int bangSlash = this.indexOfBangSlash(file);
                String toBangSlash = file.substring(0, bangSlash);
                String afterBangSlash = file.substring(bangSlash);
                file = toBangSlash + afterBangSlash;
            }
            file = file != null ? "jar:" + file.replaceFirst("\\^/", "!/") : null;
            this.setURL(url, "jarjar", "", -1, null, null, file, null, ref);
        }

        private String parseAbsoluteSpec(String spec) {
            URL url = null;
            int index = -1;
            index = this.indexOfBangSlash(spec);
            if (index == -1) {
                throw new NullPointerException("no ^/ in spec");
            }
            try {
                String innerSpec = spec.substring(0, index - 1);
                url = new URL(innerSpec);
            }
            catch (MalformedURLException e) {
                throw new NullPointerException("invalid url: " + spec + " (" + e + ")");
            }
            return spec;
        }

        private String parseContextSpec(URL url, String spec) {
            String ctxFile = url.getFile();
            if (spec.startsWith("/")) {
                int bangSlash = this.indexOfBangSlash(ctxFile);
                if (bangSlash == -1) {
                    throw new NullPointerException("malformed context url:" + url + ": no " + JarJarURLConnection.SEPARATOR);
                }
                ctxFile = ctxFile.substring(0, bangSlash);
            }
            if (!ctxFile.endsWith("/") && !spec.startsWith("/")) {
                int lastSlash = ctxFile.lastIndexOf(47);
                if (lastSlash == -1) {
                    throw new NullPointerException("malformed context url:" + url);
                }
                ctxFile = ctxFile.substring(0, lastSlash + 1);
            }
            return ctxFile + spec;
        }
    }

    private static class JarJarURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private JarJarURLStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("jarjar")) {
                return new JarJarURLStreamHandler();
            }
            return null;
        }
    }
}

