/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sf.robocode.host.security.ClassAnalyzer;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.URLJarCollector;

public final class ClassFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ByteBuffer readClassFileFromURL(URL url) {
        ByteBuffer result;
        if (url == null) {
            return null;
        }
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            URLConnection connection = URLJarCollector.openConnection((URL)url);
            is = connection.getInputStream();
            bis = new BufferedInputStream(is);
            result = ByteBuffer.allocate(8192);
            boolean done = false;
            while (true) {
                int res;
                if ((res = bis.read(result.array(), result.position(), result.remaining())) == -1) {
                    done = true;
                } else {
                    result.position(result.position() + res);
                    if (result.remaining() != 0) continue;
                }
                result.flip();
                if (!done) {
                    result = ByteBuffer.allocate(result.capacity() * 2).put(result);
                }
                if (done) break;
            }
            FileUtil.cleanupStream((Object)bis);
        }
        catch (FileNotFoundException ignore) {
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
            ByteBuffer byteBuffer = null;
            return byteBuffer;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtil.cleanupStream(bis);
            FileUtil.cleanupStream((Object)is);
        }
        FileUtil.cleanupStream((Object)is);
        return result;
    }

    public static ByteBuffer readClassFile(final URL url) {
        return AccessController.doPrivileged(new PrivilegedAction<ByteBuffer>(){

            @Override
            public ByteBuffer run() {
                return ClassFileReader.readClassFileFromURL(url);
            }
        });
    }

    public static ClassAnalyzer.RobotMainClassPredicate createMainClassPredicate(final URL rootURL) {
        return new ClassAnalyzer.RobotMainClassPredicate(new ClassAnalyzer.ByteBufferFunction(){

            @Override
            public ByteBuffer get(String binaryName) {
                URL url;
                String fileName = binaryName + ".class";
                try {
                    url = new URL(rootURL.getProtocol(), rootURL.getHost(), rootURL.getPort(), rootURL.getPath() + fileName);
                }
                catch (MalformedURLException e) {
                    Logger.logError((Throwable)e);
                    return null;
                }
                return ClassFileReader.readClassFile(url);
            }
        });
    }
}

