/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.proxies;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.HostManager;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IRobotClassLoader;
import net.sf.robocode.host.IThreadManager;
import net.sf.robocode.host.JavaHost;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.events.EventManager;
import net.sf.robocode.host.io.RobotFileSystemManager;
import net.sf.robocode.host.io.RobotOutputStream;
import net.sf.robocode.host.proxies.IHostingRobotProxy;
import net.sf.robocode.host.security.RobotThreadManager;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.RobocodeProperties;
import net.sf.robocode.peer.BadBehavior;
import net.sf.robocode.peer.ExecCommands;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.repository.IRobotItem;
import robocode.RobotStatus;
import robocode.exception.AbortedException;
import robocode.exception.DeathException;
import robocode.exception.DisabledException;
import robocode.exception.WinException;
import robocode.robotinterfaces.IBasicRobot;
import robocode.robotinterfaces.peer.IBasicRobotPeer;

abstract class HostingRobotProxy
implements IHostingRobotProxy,
IHostedThread {
    private final IRobotItem robotSpecification;
    protected EventManager eventManager;
    private final IHostManager hostManager;
    protected RobotThreadManager robotThreadManager;
    protected RobotFileSystemManager robotFileSystemManager;
    private IThreadManager threadManager;
    private IBasicRobot robot;
    protected final IRobotPeer peer;
    protected IRobotClassLoader robotClassLoader;
    protected final RobotStatics statics;
    protected RobotOutputStream out;
    private final Set<String> securityViolations = Collections.synchronizedSet(new HashSet());

    HostingRobotProxy(IRobotItem robotSpecification, IHostManager hostManager, IRobotPeer peer, RobotStatics statics) {
        this.peer = peer;
        this.statics = statics;
        this.hostManager = hostManager;
        this.robotSpecification = robotSpecification;
        this.robotClassLoader = this.getHost(robotSpecification).createLoader(robotSpecification);
        this.robotClassLoader.setRobotProxy((Object)this);
        this.out = new RobotOutputStream();
        this.robotThreadManager = new RobotThreadManager(this);
        this.loadClassBattle();
        this.robotFileSystemManager = new RobotFileSystemManager(this, hostManager.getRobotFilesystemQuota(), robotSpecification.getWritableDirectory(), robotSpecification.getReadableDirectory(), robotSpecification.getRootPath());
        this.robotFileSystemManager.initialize();
    }

    private JavaHost getHost(IRobotItem robotSpecification) {
        return (JavaHost)Container.cache.getComponent((Object)("robocode.host." + robotSpecification.getPlatform().toLowerCase()));
    }

    @Override
    public void cleanup() {
        this.robot = null;
        this.robotFileSystemManager = null;
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.robotThreadManager != null) {
            this.robotThreadManager.cleanup();
        }
        this.robotThreadManager = null;
        if (this.robotClassLoader != null) {
            this.robotClassLoader.cleanup();
            this.robotClassLoader = null;
        }
    }

    @Override
    public IRobotItem getRobotSpecification() {
        return this.robotSpecification;
    }

    @Override
    public RobotOutputStream getOut() {
        return this.out;
    }

    @Override
    public IBasicRobot getRobotObject() {
        return this.robot;
    }

    @Override
    public void println(String s) {
        this.out.println(s);
    }

    private void println(Throwable ex) {
        ex.printStackTrace(this.out);
    }

    @Override
    public RobotStatics getStatics() {
        return this.statics;
    }

    @Override
    public RobotFileSystemManager getRobotFileSystemManager() {
        return this.robotFileSystemManager;
    }

    @Override
    public ClassLoader getRobotClassloader() {
        return (ClassLoader)this.robotClassLoader;
    }

    protected abstract void initializeRound(ExecCommands var1, RobotStatus var2);

    @Override
    public void startRound(ExecCommands commands, RobotStatus status) {
        this.initializeRound(commands, status);
        this.threadManager = ((HostManager)this.hostManager).getThreadManager();
        this.robotThreadManager.start(this.threadManager);
    }

    @Override
    public void forceStopThread() {
        if (!this.robotThreadManager.forceStop()) {
            this.peer.punishBadBehavior(BadBehavior.UNSTOPPABLE);
            this.peer.setRunning(false);
        }
    }

    @Override
    public void waitForStopThread() {
        if (!this.robotThreadManager.waitForStop()) {
            this.peer.punishBadBehavior(BadBehavior.UNSTOPPABLE);
            this.peer.setRunning(false);
        }
    }

    private void loadClassBattle() {
        try {
            this.robotClassLoader.loadRobotMainClass(true);
        }
        catch (Throwable e) {
            this.println("SYSTEM: Could not load " + this.statics.getName() + " : ");
            this.println(e);
            this.drainEnergy();
        }
    }

    private boolean loadRobotRound() {
        this.robot = null;
        try {
            this.threadManager.setLoadingRobot(this);
            this.robot = this.robotClassLoader.createRobotInstance();
            if (this.robot == null) {
                this.println("SYSTEM: Skipping robot: " + this.statics.getName());
                boolean bl = false;
                return bl;
            }
            this.robot.setOut((PrintStream)this.out);
            this.robot.setPeer((IBasicRobotPeer)this);
            this.eventManager.setRobot(this.robot);
        }
        catch (IllegalAccessException e) {
            this.println("SYSTEM: Unable to instantiate this robot: " + e);
            this.println("SYSTEM: Is your constructor marked public?");
            this.println(e);
            this.robot = null;
            Logger.logError((Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            this.println("SYSTEM: An error occurred during initialization of " + this.statics.getName());
            this.println("SYSTEM: " + e);
            this.println(e);
            this.robot = null;
            Logger.logError((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.threadManager.setLoadingRobot(null);
        }
        return true;
    }

    protected abstract void executeImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (System.getProperty("java.awt.headless", "true").equals("false")) {
            this.robotThreadManager.initAWT();
        }
        if (this.robotSpecification.isValid() && this.loadRobotRound()) {
            try {
                if (this.robot != null) {
                    this.peer.setRunning(true);
                    this.eventManager.processEvents();
                    this.callUserCode();
                }
                while (this.peer.isRunning()) {
                    this.executeImpl();
                }
            }
            catch (WinException winException) {
            }
            catch (AbortedException abortedException) {
            }
            catch (DeathException e) {
                this.println("SYSTEM: " + this.statics.getName() + " has died");
            }
            catch (DisabledException e) {
                this.drainEnergy();
                String msg = e.getMessage();
                msg = msg == null ? "" : ": " + msg;
                this.println("SYSTEM: Robot disabled: " + msg);
                Logger.logMessage((String)("Robot disabled: " + this.statics.getName()));
            }
            catch (Exception e) {
                this.drainEnergy();
                this.println(e);
                if (RobocodeProperties.isTestingOn()) {
                    Logger.logError((String)(this.statics.getName() + ": Exception: " + e), (Throwable)e);
                }
                Logger.logMessage((String)(this.statics.getName() + ": Exception: " + e));
            }
            catch (ThreadDeath e) {
                this.drainEnergy();
                this.println(e);
                Logger.logMessage((String)(this.statics.getName() + " stopped successfully."));
                throw e;
            }
            catch (Throwable t) {
                this.drainEnergy();
                this.println(t);
                if (RobocodeProperties.isTestingOn()) {
                    Logger.logError((String)(this.statics.getName() + ": Throwable: " + t), (Throwable)t);
                }
                Logger.logMessage((String)(this.statics.getName() + ": Throwable: " + t));
            }
            finally {
                this.waitForBattleEndImpl();
            }
        } else {
            this.drainEnergy();
            this.peer.punishBadBehavior(BadBehavior.CANNOT_START);
            this.waitForBattleEndImpl();
        }
        this.peer.setRunning(false);
        HostingRobotProxy hostingRobotProxy = this;
        synchronized (hostingRobotProxy) {
            this.notifyAll();
        }
    }

    private void callUserCode() {
        Runnable runnable = this.robot.getRobotRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }

    protected abstract void waitForBattleEndImpl();

    @Override
    public void drainEnergy() {
        this.peer.drainEnergy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void punishSecurityViolation(String message) {
        Set<String> set = this.securityViolations;
        synchronized (set) {
            String key = message;
            if (key.startsWith("Preventing Thread-")) {
                key = key.replaceAll("\\d+", "X");
            }
            if (!this.securityViolations.contains(key)) {
                this.securityViolations.add(key);
                Logger.logError((String)message);
                this.println("SYSTEM: " + message);
                if (this.securityViolations.size() == 1) {
                    this.peer.drainEnergy();
                    this.peer.punishBadBehavior(BadBehavior.SECURITY_VIOLATION);
                }
            }
        }
    }
}

