/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import net.sf.robocode.host.security.RobocodePermission;

public class SecureInputStream
extends InputStream {
    private RobocodePermission inputPermission = null;
    private InputStream in = null;

    public SecureInputStream(InputStream in) {
        this.in = in;
        this.inputPermission = new RobocodePermission("System.in");
    }

    @Override
    public final int available() throws IOException {
        this.checkAccess();
        return this.in.available();
    }

    private void checkAccess() {
        AccessController.checkPermission(this.inputPermission);
    }

    @Override
    public final void close() throws IOException {
        this.checkAccess();
        this.in.close();
    }

    @Override
    public final synchronized void mark(int readlimit) {
        this.checkAccess();
        this.in.mark(readlimit);
    }

    @Override
    public final boolean markSupported() {
        this.checkAccess();
        return this.in.markSupported();
    }

    @Override
    public final int read() throws IOException {
        this.checkAccess();
        return this.in.read();
    }

    @Override
    public final int read(byte[] b) throws IOException {
        this.checkAccess();
        return this.in.read(b);
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        this.checkAccess();
        return this.in.read(b, off, len);
    }

    @Override
    public final synchronized void reset() throws IOException {
        this.checkAccess();
        this.in.reset();
    }

    @Override
    public final long skip(long n) throws IOException {
        this.checkAccess();
        return this.in.skip(n);
    }
}

