/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host.security;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.robocode.core.Container;
import net.sf.robocode.host.IHostedThread;
import net.sf.robocode.host.IRobotClassLoader;
import net.sf.robocode.host.security.ClassAnalyzer;
import net.sf.robocode.host.security.ClassFileReader;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.RobocodeProperties;
import robocode.annotation.SafeStatic;
import robocode.robotinterfaces.IBasicRobot;

public class RobotClassLoader
extends URLClassLoader
implements IRobotClassLoader {
    static final String UNTRUSTED_URL = "https://robocode.sourceforge.io/untrusted";
    private static final PermissionCollection EMPTY_PERMISSIONS = new Permissions();
    private final String fullClassName;
    private ClassLoader parent;
    private CodeSource codeSource;
    private IHostedThread robotProxy;
    private Class<?> robotClass;
    private Set<String> referencedClasses = new HashSet<String>();
    private Set<String> foundSystemClasses = new HashSet<String>();
    private String[] staticRobotInstanceWarning;

    public RobotClassLoader(URL robotClassPath, String robotFullClassName) {
        super(new URL[]{robotClassPath}, Container.systemLoader);
        this.fullClassName = robotFullClassName;
        this.parent = this.getParent();
        try {
            this.codeSource = new CodeSource(new URL(UNTRUSTED_URL), (Certificate[])null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setRobotProxy(Object robotProxy) {
        this.robotProxy = (IHostedThread)robotProxy;
    }

    @Override
    public synchronized void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        if (RobocodeProperties.isSecurityOn()) {
            this.testPackages(name);
        }
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("kotlin.")) {
            return super.loadClass(name, resolve);
        }
        if (!name.startsWith("robocode") && (result = this.loadRobotClassLocally(name, resolve)) != null) {
            return result;
        }
        return this.parent.loadClass(name);
    }

    private void testPackages(String name) throws ClassNotFoundException {
        if (name.startsWith("net.sf.robocode")) {
            String message = "Robots are not allowed to reference Robocode engine in package: net.sf.robocode";
            this.punishSecurityViolation(message);
            throw new ClassNotFoundException(message);
        }
        if (name.startsWith("robocode.control")) {
            String message = "Robots are not allowed to reference Robocode engine in package: robocode.control";
            this.punishSecurityViolation(message);
            throw new ClassNotFoundException(message);
        }
        if (RobocodeProperties.isSecurityOn() && name.startsWith("javax.swing")) {
            String message = "Robots are not allowed to reference Robocode engine in package: javax.swing";
            this.punishSecurityViolation(message);
            throw new ClassNotFoundException(message);
        }
    }

    private Class<?> loadRobotClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        ByteBuffer resource;
        Class<?> result = this.findLoadedClass(name);
        if (result == null && (resource = this.findLocalResource(name)) != null) {
            result = this.defineClass(name, resource, this.codeSource);
            if (resolve) {
                this.resolveClass(result);
            }
            ClassAnalyzer.getReferencedClasses(resource, this.referencedClasses);
        }
        return result;
    }

    private ByteBuffer findLocalResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ByteBuffer>(){

            @Override
            public ByteBuffer run() {
                String path = name.replace('.', '/').concat(".class");
                URL url = RobotClassLoader.this.findResource(path);
                return ClassFileReader.readClassFileFromURL(url);
            }
        });
    }

    private void punishSecurityViolation(String message) {
        if (this.robotProxy != null) {
            this.robotProxy.punishSecurityViolation(message);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        if (RobocodeProperties.isSecurityOn()) {
            return EMPTY_PERMISSIONS;
        }
        return super.getPermissions(codesource);
    }

    public String[] getReferencedClasses() {
        return this.referencedClasses.toArray(new String[0]);
    }

    public synchronized Class<?> loadRobotMainClass(boolean resolve) throws ClassNotFoundException {
        if (this.fullClassName == null) {
            return null;
        }
        try {
            if (this.robotClass == null) {
                this.robotClass = this.loadClass(this.fullClassName, resolve);
                if (!IBasicRobot.class.isAssignableFrom(this.robotClass)) {
                    return null;
                }
                if (resolve) {
                    HashSet<String> clone;
                    this.robotClass.getMethods();
                    do {
                        clone = new HashSet<String>(this.referencedClasses);
                        for (String reference : clone) {
                            this.testPackages(reference);
                            if (this.isSystemClass(reference)) continue;
                            this.loadClass(reference, true);
                        }
                    } while (this.referencedClasses.size() != clone.size());
                }
            } else {
                this.warnIfStaticRobotInstanceFields();
            }
        }
        catch (Throwable e) {
            this.robotClass = null;
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        return this.robotClass;
    }

    public IBasicRobot createRobotInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.loadRobotMainClass(true);
        return (IBasicRobot)this.robotClass.newInstance();
    }

    public void cleanup() {
        for (String className : this.getReferencedClasses()) {
            this.cleanStaticReferences(className);
        }
        this.parent = null;
        this.codeSource = null;
        this.robotProxy = null;
        this.robotClass = null;
        this.referencedClasses = null;
        this.foundSystemClasses = null;
    }

    private void cleanStaticReferences(String className) {
        if (this.isSystemClass(className)) {
            return;
        }
        Class<?> type = null;
        try {
            type = this.loadRobotClassLocally(className, false);
            if (type != null) {
                for (Field field : this.getAllFields(new ArrayList<Field>(), type)) {
                    if (!RobotClassLoader.isStaticReference(field)) continue;
                    this.cleanStaticReference(field);
                }
            }
        }
        catch (Throwable t) {
            Logger.logError((Throwable)t);
        }
    }

    private void warnIfStaticRobotInstanceFields() {
        if (this.staticRobotInstanceWarning == null) {
            ArrayList<Field> staticRobotReferences = new ArrayList<Field>();
            for (String className : this.getReferencedClasses()) {
                if (this.isSystemClass(className)) continue;
                Class<?> type = null;
                try {
                    type = this.loadRobotClassLocally(className, false);
                }
                catch (Throwable t) {
                    continue;
                }
                if (type == null) continue;
                for (Field field : this.getAllFields(new ArrayList<Field>(), type)) {
                    if (!RobotClassLoader.isStaticReference(field) || !IBasicRobot.class.isAssignableFrom(field.getType()) || field.getAnnotation(SafeStatic.class) != null) continue;
                    staticRobotReferences.add(field);
                }
            }
            if (!staticRobotReferences.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Warning: ").append(this.fullClassName).append(" uses static reference to a robot with the following field(s):");
                for (Field field : staticRobotReferences) {
                    buf.append("\n\t").append(field.getDeclaringClass().getName()).append('.').append(field.getName()).append(", which points to a ").append(field.getType().getName());
                }
                this.staticRobotInstanceWarning = new String[]{buf.toString(), "Static references to robots can cause unwanted behaviour with the robot using these.", "Please change static robot references to non-static references and recompile the robot."};
            } else {
                this.staticRobotInstanceWarning = new String[0];
            }
        } else if (this.staticRobotInstanceWarning.length == 0) {
            return;
        }
        if (this.robotProxy != null) {
            for (String line : this.staticRobotInstanceWarning) {
                this.robotProxy.getOut().println("SYSTEM: " + line);
            }
        }
    }

    private void cleanStaticReference(Field field) {
        if (field.getName().startsWith("const__")) {
            return;
        }
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            int modifiers = modifiersField.getInt(field);
            modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
            field.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private List<Field> getAllFields(List<Field> fields, Class<?> type) {
        if (type == null || this.isSystemClass(type.getName())) {
            return fields;
        }
        try {
            Collections.addAll(fields, type.getDeclaredFields());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (type.getSuperclass() != null) {
            fields = this.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    private boolean isSystemClass(String className) {
        boolean isSystemClass = this.foundSystemClasses.contains(className);
        if (!isSystemClass) {
            try {
                if (this.findSystemClass(className) != null) {
                    this.foundSystemClasses.add(className);
                    isSystemClass = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return isSystemClass;
    }

    private static boolean isStaticReference(Field field) {
        return Modifier.isStatic(field.getModifiers()) && !field.getType().isPrimitive() && !field.isEnumConstant() && !field.isSynthetic();
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            if (name.startsWith("jdk/") || name.startsWith("java/") || name.startsWith("javax/") || name.startsWith("sun/") || name.startsWith("net.sf.robocode/")) {
                return null;
            }
            URL[] urls = this.getURLs();
            if (urls != null) {
                for (URL u : urls) {
                    if (u == null) continue;
                    try {
                        URL tmp = new URL(u.getProtocol(), u.getHost(), u.getPort(), u.getPath() + name);
                        if (u.openConnection() != null) {
                            return tmp;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return url;
    }
}

