/*---------------------------------------------------------------------------
 * 2005 NORSYS
 * main author : nono
 *
 * This software is a computer program whose purpose is to provide abstraction
 * for accessing directory data sources within java applications.
 *
 * This software is governed by the CeCILL  license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 * Created on Oct 20, 2005
 * --------------------------------------------------------------------------*/
package speculoos.commons.mockldap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestDirContextFactory implements InitialContextFactory {

    public static final String TESTSOURCE = "speculoos.commons.mockldap.testsource";

    private static ThreadLocal instance = new ThreadLocal();
    private static ThreadLocal instanceSrc = new ThreadLocal();
    
    private final Log log = LogFactory.getLog(TestDirContextFactory.class);

    public Context getInitialContext(Hashtable arg0) throws NamingException {
        /* find file */
        String src = (String) arg0.get(TESTSOURCE);
        if (src == null)
            throw new NamingException("no test file given");        
        String instanceSrcVal = (String) instanceSrc.get();
        if (instanceSrcVal != null && instanceSrcVal.equals(src)) {
        	return (Context) instance.get();
        } else { 
	        LDIFParser p = new LDIFParser();
	        try {
	            log.info("Parsing LDIF file "+src);
	            /* extract stream from ressource  name */
	            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(src);
	            Context root = p.parse(is);
	            instance.set(root);
	            instanceSrc.set(src);
	            log.info("Done parsing LDIF file :" +p.getEntryCount()+" entries in root node "+root.getNameInNamespace());
	            return root;
	        } catch (IOException e) {
	            throw new NamingException("I/O error :" + e.getLocalizedMessage());
	        }
        }
    }

}
