/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.check;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.staccatocommons.check.format.Var;
import net.sf.staccatocommons.check.internal.EmptyAwareTypes;
import net.sf.staccatocommons.check.internal.SizeAwareTypes;
import net.sf.staccatocommons.defs.partial.ContainsAware;
import net.sf.staccatocommons.defs.partial.EmptyAware;
import net.sf.staccatocommons.defs.partial.SizeAware;
import net.sf.staccatocommons.defs.type.EmptyAwareType;
import net.sf.staccatocommons.defs.type.NumberType;
import net.sf.staccatocommons.defs.type.SizeAwareType;

public abstract class Check<ExceptionType extends Throwable> {
    protected ExceptionType createVarException(VarFailure failure) {
        return this.createException(failure);
    }

    protected abstract ExceptionType createException(Failure var1);

    public <Nothing> Nothing fail(String message, Object ... args) throws ExceptionType {
        throw this.createException(new Failure(String.format(message, args)));
    }

    public <Nothing> Nothing failVar(String varName, Object var, String message, Object ... args) throws ExceptionType {
        throw this.createVarException(new VarFailure(varName, var, String.format(message, args)));
    }

    public final Check<ExceptionType> thatVar(String varName, Object var, boolean condition, String message, Object ... args) throws ExceptionType {
        if (!condition) {
            this.failVar(varName, var, message, args);
        }
        return this;
    }

    public final Check<ExceptionType> that(boolean condition, String message, Object ... args) throws ExceptionType {
        if (!condition) {
            this.fail(message, args);
        }
        return this;
    }

    public final Check<ExceptionType> isNotNull(String varName, Object var) throws ExceptionType {
        return this.thatVar(varName, var, var != null, "must not be null", new Object[0]);
    }

    public final Check<ExceptionType> isNull(String varName, Object var) throws ExceptionType {
        return this.thatVar(varName, var, var == null, "must be null", new Object[0]);
    }

    public final Check<ExceptionType> isTrue(String varName, boolean var) throws ExceptionType {
        return this.thatVar(varName, var, var, "must be true", new Object[0]);
    }

    public final Check<ExceptionType> isFalse(String varName, boolean var) throws ExceptionType {
        return this.thatVar(varName, var, !var, "must be false", new Object[0]);
    }

    public final Check<ExceptionType> matches(String varName, String var, String regex) throws ExceptionType {
        return this.isNotNull(varName, var).matches(varName, var, Pattern.compile(regex));
    }

    public final Check<ExceptionType> matches(String varName, String var, Pattern pattern) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, pattern.matcher(var).matches(), "must match %s", pattern.pattern());
    }

    public final Check<ExceptionType> isEmpty(String varName, Collection<?> var) throws ExceptionType {
        return this.isEmpty(varName, (Object)var, (EmptyAwareType)SizeAwareTypes.COLLECTION);
    }

    public final Check<ExceptionType> isEmpty(String varName, Map<?, ?> var) throws ExceptionType {
        return this.isEmpty(varName, (Object)var, (EmptyAwareType)SizeAwareTypes.MAP);
    }

    public final Check<ExceptionType> isEmpty(String varName, Iterable<?> var) throws ExceptionType {
        return this.isEmpty(varName, var, EmptyAwareTypes.ITERABLE);
    }

    public final Check<ExceptionType> isEmpty(String varName, CharSequence var) throws ExceptionType {
        return this.isEmpty(varName, (Object)var, (EmptyAwareType)SizeAwareTypes.CHAR_SEQUENCE);
    }

    public final Check<ExceptionType> isEmpty(String varName, EmptyAware var) throws ExceptionType {
        return this.isEmpty(varName, var, EmptyAwareTypes.EMPTY_AWARE);
    }

    public final <A> Check<ExceptionType> isEmpty(String varName, A var, EmptyAwareType<A> type) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, type.isEmpty(var), "must be empty", new Object[0]);
    }

    public final Check<ExceptionType> isInstanceOf(String varName, Object var, Class<?> expectedClass) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, expectedClass.isInstance(var), "must be instance of class %s", expectedClass);
    }

    public final Check<ExceptionType> isSize(String varName, Collection<?> var, int size) throws ExceptionType {
        return this.isSize(varName, var, size, SizeAwareTypes.COLLECTION);
    }

    public final Check<ExceptionType> isSize(String varName, CharSequence var, int size) throws ExceptionType {
        return this.isSize(varName, var, size, SizeAwareTypes.CHAR_SEQUENCE);
    }

    public final Check<ExceptionType> isSize(String varName, SizeAware var, int size) throws ExceptionType {
        return this.isSize(varName, var, size, SizeAwareTypes.SIZE_AWARE);
    }

    public final Check<ExceptionType> isSize(String varName, Map<?, ?> var, int size) throws ExceptionType {
        return this.isSize(varName, var, size, SizeAwareTypes.MAP);
    }

    public final <A> Check<ExceptionType> isSize(String varName, A var, int expectedSize, SizeAwareType<A> type) throws ExceptionType {
        return this.thatVar(varName, var, type.size(var) == expectedSize, "must be of size %s, but was %s", expectedSize, type.size(var));
    }

    public final Check<ExceptionType> isMinSize(String varName, Collection<?> var, int minSize) throws ExceptionType {
        return this.isMinSize(varName, var, minSize, SizeAwareTypes.COLLECTION);
    }

    public final <A> Check<ExceptionType> isMinSize(String varName, A var, int minSize, SizeAwareType<A> type) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, type.size(var) >= minSize, "must be at least of size %s, but was %s", minSize, type.size(var));
    }

    public final Check<ExceptionType> isMaxSize(String varName, Collection<?> var, int minSize) throws ExceptionType {
        return this.isMaxSize(varName, var, minSize, SizeAwareTypes.COLLECTION);
    }

    public final <A> Check<ExceptionType> isMaxSize(String varName, A var, int maxSize, SizeAwareType<A> type) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, type.size(var) <= maxSize, "must be at most of size %s, but was %s", maxSize, type.size(var));
    }

    public final Check<ExceptionType> isNotNegative(String varName, long var) throws ExceptionType {
        return this.isNotNegative(varName, (Object)var, var >= 0L);
    }

    public final Check<ExceptionType> isNotNegative(String varName, int var) throws ExceptionType {
        return this.isNotNegative(varName, (Object)var, var >= 0);
    }

    public final Check<ExceptionType> isNotNegative(String varName, double var) throws ExceptionType {
        return this.isNotNegative(varName, (Object)var, var >= 0.0);
    }

    public final Check<ExceptionType> isNotNegative(String varName, float var) throws ExceptionType {
        return this.isNotNegative(varName, Float.valueOf(var), var >= 0.0f);
    }

    public final Check<ExceptionType> isNotNegative(String varName, BigDecimal var) throws ExceptionType {
        return super.isNotNegative(varName, var, var.compareTo(BigDecimal.ZERO) >= 0);
    }

    public final Check<ExceptionType> isNotNegative(String varName, BigInteger var) throws ExceptionType {
        return super.isNotNegative(varName, var, var.compareTo(BigInteger.ZERO) >= 0);
    }

    public final <A> Check<ExceptionType> isNotNegative(String varName, A var, NumberType<A> type) throws ExceptionType {
        return this.isNotNegative(varName, var, !type.isNegative(var));
    }

    private Check<ExceptionType> isNotNegative(String varName, Object number, boolean notNegative) throws ExceptionType {
        return this.thatVar(varName, number, notNegative, "must be not negative", new Object[0]);
    }

    public final <A> Check<ExceptionType> isNotZero(String varName, A var, NumberType<A> type) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, !type.isZero(var), "must not be zero", new Object[0]);
    }

    public final <A> Check<ExceptionType> isZero(String varName, A var, NumberType<A> type) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, type.isZero(var), "must be zero", new Object[0]);
    }

    public final Check<ExceptionType> isNotEmpty(String varName, EmptyAware var) throws ExceptionType {
        return this.isNotEmpty(varName, var, EmptyAwareTypes.EMPTY_AWARE);
    }

    public final Check<ExceptionType> isNotEmpty(String varName, Collection<?> var) throws ExceptionType {
        return this.isNotEmpty(varName, (Object)var, (EmptyAwareType)SizeAwareTypes.COLLECTION);
    }

    public final Check<ExceptionType> isNotEmpty(String varName, CharSequence var) throws ExceptionType {
        return this.isNotEmpty(varName, (Object)var, (EmptyAwareType)SizeAwareTypes.CHAR_SEQUENCE);
    }

    public final Check<ExceptionType> isNotEmpty(String varName, Map<?, ?> var) throws ExceptionType {
        return this.isNotEmpty(varName, (Object)var, (EmptyAwareType)SizeAwareTypes.MAP);
    }

    public final Check<ExceptionType> isNotEmpty(String varName, Iterable<?> var) throws ExceptionType {
        return this.isNotEmpty(varName, var, EmptyAwareTypes.ITERABLE);
    }

    public final <A> Check<ExceptionType> isNotEmpty(String varName, A var, EmptyAwareType<A> type) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, !type.isEmpty(var), "must not be empty", new Object[0]);
    }

    public final Check<ExceptionType> isPositive(String varName, long var) throws ExceptionType {
        return this.isPositive(varName, (Object)var, var > 0L);
    }

    public final Check<ExceptionType> isPositive(String varName, int var) throws ExceptionType {
        return this.isPositive(varName, (Object)var, var > 0);
    }

    public final Check<ExceptionType> isPositive(String varName, double var) throws ExceptionType {
        return this.isPositive(varName, (Object)var, var > 0.0);
    }

    public final Check<ExceptionType> isPositive(String varName, float var) throws ExceptionType {
        return this.isPositive(varName, Float.valueOf(var), var > 0.0f);
    }

    public final Check<ExceptionType> isPositive(String varName, BigDecimal var) throws ExceptionType {
        return super.isPositive(varName, var, var.compareTo(BigDecimal.ZERO) > 0);
    }

    public final Check<ExceptionType> isPositive(String varName, BigInteger var) throws ExceptionType {
        return super.isPositive(varName, var, var.compareTo(BigInteger.ZERO) > 0);
    }

    public final <A> Check<ExceptionType> isPositive(String varName, A var, NumberType<A> type) throws ExceptionType {
        return super.isPositive(varName, var, type.isPositive(var));
    }

    private Check<ExceptionType> isPositive(String varName, Object var, boolean positive) throws ExceptionType {
        return this.thatVar(varName, var, positive, "must be positive", new Object[0]);
    }

    public final <T extends Comparable<T>> Check<ExceptionType> isBetween(String varName, T var, T min, T max) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, var.compareTo(max) <= 0 && var.compareTo(min) >= 0, "must be between %s and %s", min, max);
    }

    public final <T> Check<ExceptionType> contains(String varName, ContainsAware<T> var, T element) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, var.contains(element), "must contain %s", element);
    }

    public final <T> Check<ExceptionType> isIn(String varName, T var, ContainsAware<T> container) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, container.contains(var), "must be in %s", container);
    }

    public final <T extends Comparable<T>> Check<ExceptionType> isGreaterThan(String varName, T var, T other) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, var.compareTo(other) > 0, "must be greater than %s", other);
    }

    public final <T extends Comparable<T>> Check<ExceptionType> isGreaterThanOrEqualTo(String varName, T var, T other) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, var.compareTo(other) >= 0, "must be greater than or equal to %s", other);
    }

    public final <T extends Comparable<T>> Check<ExceptionType> isLessThan(String varName, T var, T other) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, var.compareTo(other) < 0, "must be less than %s", other);
    }

    public final <T extends Comparable<T>> Check<ExceptionType> isLessThanOrEqualTo(String varName, T var, T other) throws ExceptionType {
        return this.isNotNull(varName, var).thatVar(varName, var, var.compareTo(other) <= 0, "must be less than or equal to %s", other);
    }

    public static class Failure {
        private final String message;

        public Failure(String message) {
            this.message = message;
        }

        public String createMessage() {
            return this.message;
        }
    }

    public static class VarFailure
    extends Failure {
        private final String varName;
        private final Object var;

        public VarFailure(String varName, Object var, String message) {
            super(message);
            this.varName = varName;
            this.var = var;
        }

        public Object getVar() {
            return this.var;
        }

        public String getVarName() {
            return this.varName;
        }

        public String createSimpleMessage() {
            return super.createMessage();
        }

        @Override
        public String createMessage() {
            return Var.format(this.varName, this.var, ": " + super.createMessage());
        }
    }
}

