/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io;

import java.io.File;
import java.io.IOException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.io.BreadthFirst;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.commons.io.FileUtils;

public class Directory {
    private final File file;

    public Directory(@NonNull String pathname) {
        Ensure.isNotNull((String)"var0", (Object)pathname);
        this(new File(pathname));
    }

    public Directory(@NonNull File file) {
        Ensure.isNotNull((String)"var0", (Object)file);
        Ensure.thatVar((String)"file", (Object)file, (boolean)file.isDirectory(), (String)"must denote a directory", (Object[])new Object[0]);
        this.file = file;
    }

    @NonNull
    public String getAbsolutePath() {
        return this.getFile().getAbsolutePath();
    }

    @NonNull
    public File getFile() {
        return this.file;
    }

    @NonNull
    public Stream<File> getFileStream() {
        return Streams.cons((Object[])this.file.listFiles());
    }

    @NonNull
    public Stream<File> getBreadthFirstFileStream() {
        return Streams.cons((Object[])this.file.listFiles()).transform((Applicable)BreadthFirst.INSTANCE);
    }

    @NonNull
    public Stream<File> getDepthFirstFileStream() {
        return Streams.cons((Object[])this.file.listFiles()).flatMap((Function)new AbstractFunction<File, Stream<File>>(){

            public Stream<File> apply(File arg) {
                if (arg.isDirectory()) {
                    return new Directory(arg).getDepthFirstFileStream();
                }
                return Streams.cons((Object)arg);
            }
        });
    }

    @NonNull
    public Stream<File> getRecurseFileStream() {
        return this.getDepthFirstFileStream();
    }

    public long size() {
        return FileUtils.sizeOfDirectory((File)this.getFile());
    }

    public Directory clean() throws IOException {
        FileUtils.cleanDirectory((File)this.getFile());
        return this;
    }

    public Directory copy(@NonNull Directory destination) throws IOException {
        Ensure.isNotNull((String)"var0", (Object)destination);
        FileUtils.copyDirectory((File)this.file, (File)destination.getFile());
        return this;
    }
}

