/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.util.concurrent.Callable;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.commons.lang.UnhandledException;

public class SoftException
extends UnhandledException {
    private static final long serialVersionUID = 4364656280386270636L;

    SoftException(@NonNull Exception cause) {
        super((Throwable)cause);
    }

    @NonNull
    public static RuntimeException soften(@NonNull Exception exception) {
        Ensure.isNotNull((String)"var0", (Object)exception);
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new SoftException(exception);
    }

    @NonNull
    public static Exception harden(@NonNull SoftException e) {
        Ensure.isNotNull((String)"var0", (Object)((Object)e));
        return (Exception)e.getCause();
    }

    @NonNull
    public static Exception harden(@NonNull RuntimeException runtimeException) {
        Ensure.isNotNull((String)"var0", (Object)runtimeException);
        Throwable nonRuntime = SoftException.findNonRuntime(runtimeException);
        if (nonRuntime instanceof Exception) {
            return (Exception)nonRuntime;
        }
        return runtimeException;
    }

    private static Throwable findNonRuntime(RuntimeException e) {
        if (e.getCause() instanceof RuntimeException) {
            return SoftException.findNonRuntime((RuntimeException)e.getCause());
        }
        return e.getCause();
    }

    public static <T> T callOrSoften(@NonNull Callable<T> callable) {
        Ensure.isNotNull((String)"var0", callable);
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw SoftException.soften(e);
        }
    }

    public static <T> T valueOrHarden(@NonNull Thunk<T> thunk) throws Exception {
        Ensure.isNotNull((String)"var0", thunk);
        try {
            return (T)thunk.value();
        }
        catch (SoftException e) {
            throw SoftException.harden(e);
        }
        catch (RuntimeException e) {
            throw SoftException.harden(e);
        }
    }
}

