/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.function;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Applicable2;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.function.internal.ApplicableFunction;
import net.sf.staccatocommons.lang.function.internal.ConstantFunction;
import net.sf.staccatocommons.lang.function.internal.IdentityFunction;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Functions {
    private Functions() {
    }

    @NonNull
    public static <A, B> Function<A, B> from(@NonNull Applicable<? super A, ? extends B> applicable) {
        Ensure.isNotNull((String)"var0", applicable);
        if (applicable instanceof Function) {
            return (Function)applicable;
        }
        return new ApplicableFunction<A, B>(applicable);
    }

    @NonNull
    public static <A, B, C> Function2<A, B, C> from(final @NonNull Applicable2<? super A, ? super B, ? extends C> applicable) {
        Ensure.isNotNull((String)"var0", applicable);
        if (applicable instanceof Function2) {
            return (Function2)applicable;
        }
        return new AbstractFunction2<A, B, C>(){

            public C apply(A arg0, B arg1) {
                return applicable.apply(arg0, arg1);
            }
        };
    }

    @Constant
    public static <A> Function<A, A> identity() {
        return IdentityFunction.identity();
    }

    @NonNull
    public static <A, B> Function<A, B> constant(B value) {
        return new ConstantFunction(value);
    }

    @NonNull
    public static <A, B> Function<A, B> constant(final @NonNull Thunk<B> thunk) {
        Ensure.isNotNull((String)"var0", thunk);
        return new AbstractFunction<A, B>(){

            public B apply(A arg) {
                return thunk.value();
            }
        };
    }

    public static <A> Function<A, A> impure(final @NonNull Executable<? super A> block) {
        Ensure.isNotNull((String)"var0", block);
        return new AbstractFunction<A, A>(){

            public A apply(A arg) {
                block.exec(arg);
                return arg;
            }
        };
    }
}

