/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.predicate.internal;

import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.lang.predicate.internal.TopLevelPredicate;

public final class NullPredicates {
    private static final Predicate NULL = new Null();
    private static final Predicate NOT_NULL = new NotNull();

    public static Predicate notNull() {
        return NOT_NULL;
    }

    public static Predicate null_() {
        return NULL;
    }

    private static class NotNull<T>
    extends TopLevelPredicate<T> {
        private static final long serialVersionUID = 876641857208937901L;

        private NotNull() {
        }

        @Override
        public boolean eval(T argument) {
            return argument != null;
        }

        @Override
        public Predicate<T> not() {
            return NULL;
        }
    }

    private static class Null<T>
    extends TopLevelPredicate<T> {
        private static final long serialVersionUID = -7208581270049483766L;

        private Null() {
        }

        @Override
        public boolean eval(T argument) {
            return argument == null;
        }

        @Override
        public Predicate<T> not() {
            return NOT_NULL;
        }
    }
}

