/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.sf.testng.databinding.AbstractDataSource;
import net.sf.testng.databinding.DataSource;
import net.sf.testng.databinding.core.error.MissingPropertiesException;
import net.sf.testng.databinding.core.util.MethodParametersAndPropertiesConstructorMatcher;
import net.sf.testng.databinding.csv.HeaderNameFileLinkingMapper;
import net.sf.testng.databinding.csv.HeaderNameMapper;
import net.sf.testng.databinding.csv.Mapper;
import net.sf.testng.databinding.util.ConstructorMatcher;
import net.sf.testng.databinding.util.Constructors;
import net.sf.testng.databinding.util.MethodParameter;

@DataSource(name="csv")
public class CsvDataSource
extends AbstractDataSource {
    private final CSVReader csvReader;
    private final Mapper mapper;
    private String[] nextLine;

    public CsvDataSource(List<MethodParameter> parameters, Properties properties) throws Exception {
        this.checkProperties(properties);
        this.csvReader = this.createCsvReader(properties);
        this.mapper = this.createMapper(parameters, properties);
        this.mapper.init(this.csvReader);
    }

    private void checkProperties(Properties properties) {
        ArrayList<String> missingKeys = new ArrayList<String>();
        if (!properties.containsKey("url")) {
            missingKeys.add("url");
        }
        if (missingKeys.size() > 0) {
            throw new MissingPropertiesException(missingKeys);
        }
    }

    private CSVReader createCsvReader(Properties properties) throws Exception {
        URL url = this.resolveURL(properties.getProperty("url"));
        Charset charset = Charset.forName(properties.getProperty("charset", "UTF-8"));
        char separator = properties.getProperty("separator", ",").charAt(0);
        char quotechar = properties.getProperty("quoteChar", "\"").charAt(0);
        char escape = properties.getProperty("escapeChar", "\\").charAt(0);
        int line = Integer.parseInt(properties.getProperty("linesToSkip", "0"));
        boolean strictQuotes = Boolean.parseBoolean(properties.getProperty("strictQuotes", "false"));
        boolean ignoreLeadingWhiteSpace = Boolean.parseBoolean(properties.getProperty("ignoreLeadingWhiteSpace", "false"));
        BufferedReader rawReader = new BufferedReader(new InputStreamReader(url.openStream(), charset));
        return new CSVReader((Reader)rawReader, separator, quotechar, escape, line, strictQuotes, ignoreLeadingWhiteSpace);
    }

    private URL resolveURL(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            url = ((Object)((Object)this)).getClass().getResource(urlString);
        }
        return url;
    }

    private Mapper createMapper(List<MethodParameter> parameters, Properties properties) throws Exception {
        Mapper mapper;
        String mapperDefinition = properties.getProperty("mapper", "headerNameMapper");
        if ("headerNameMapper".equals(mapperDefinition)) {
            mapper = new HeaderNameMapper(parameters, properties);
        } else if ("headerNameFileLinkingMapper".equals(mapperDefinition)) {
            mapper = new HeaderNameFileLinkingMapper(parameters, properties);
        } else {
            Class<?> mapperClass = Class.forName(mapperDefinition);
            MethodParametersAndPropertiesConstructorMatcher matcher = new MethodParametersAndPropertiesConstructorMatcher();
            Constructor constructor = Constructors.getMatchingConstructor(mapperClass, (ConstructorMatcher)matcher);
            mapper = (Mapper)constructor.newInstance(parameters, properties);
        }
        return mapper;
    }

    public boolean hasNext() {
        try {
            this.nextLine = this.csvReader.readNext();
            return this.nextLine != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object[] next() {
        if (this.nextLine != null) {
            return this.mapper.createBeans(this.nextLine);
        }
        throw new NoSuchElementException();
    }
}

