/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.csv;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sf.testng.databinding.AbstractDataSource;
import net.sf.testng.databinding.DataSource;
import net.sf.testng.databinding.TestOutput;
import net.sf.testng.databinding.core.error.ErrorCollector;
import net.sf.testng.databinding.core.error.MissingPropertiesException;
import net.sf.testng.databinding.core.error.MultipleConfigurationErrorsException;
import net.sf.testng.databinding.core.util.Types;
import net.sf.testng.databinding.csv.CsvDataSource;
import net.sf.testng.databinding.csv.HeaderNameMapper;
import net.sf.testng.databinding.util.MethodParameter;

@DataSource(name="csv-file-at-once")
public class CsvFileAtOnceDataSource
extends AbstractDataSource {
    private final CsvDataSource delegate;

    public CsvFileAtOnceDataSource(List<MethodParameter> parameters, Properties properties) throws Exception {
        this.checkProperties(properties);
        this.checkParameters(parameters);
        List<MethodParameter> adjustedParameters = this.prepareParameters(parameters);
        Properties adjustedProperties = this.prepareProperties(properties);
        this.delegate = new CsvDataSource(adjustedParameters, adjustedProperties);
    }

    private void checkProperties(Properties properties) {
        if (!properties.containsKey("url")) {
            throw new MissingPropertiesException(new String[]{"url"});
        }
    }

    private void checkParameters(List<MethodParameter> parameters) {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        if (parameters.size() > 1) {
            ErrorCollector errorCollector = new ErrorCollector("too many parameters");
            errorCollector.addError("The method specifies too many parameters for this data provider strategy.");
            errorCollectors.add(errorCollector);
        } else {
            MethodParameter parameter = parameters.get(0);
            Type type = parameter.getType();
            ErrorCollector errorCollector = new ErrorCollector(type);
            if (parameter.getAnnotation(TestOutput.class) == null) {
                errorCollector.addError("The parameter must be annotated with @TestOutput.");
            }
            if (!Types.isListOfObjectsType((Type)type)) {
                errorCollector.addError("The parameter must either be a list of primitives or of a Java Bean type.");
            }
            if (errorCollector.hasErrors()) {
                errorCollectors.add(errorCollector);
            }
        }
        if (errorCollectors.size() > 0) {
            throw new MultipleConfigurationErrorsException(errorCollectors);
        }
    }

    private List<MethodParameter> prepareParameters(List<MethodParameter> parameters) {
        return Arrays.asList(Types.unwrapIfPossible((MethodParameter)parameters.get(0)));
    }

    private Properties prepareProperties(Properties properties) {
        if (!properties.containsKey("mapper")) {
            properties.setProperty("mapper", HeaderNameMapper.class.getName());
        }
        return properties;
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object[] next() {
        ArrayList<Object> list = new ArrayList<Object>();
        do {
            list.add(this.delegate.next()[0]);
        } while (this.delegate.hasNext());
        return new Object[]{list};
    }
}

