/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.csv;

import java.beans.IntrospectionException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.testng.databinding.core.error.ErrorCollector;
import net.sf.testng.databinding.core.util.Types;
import net.sf.testng.databinding.csv.CsvDataSource;
import net.sf.testng.databinding.csv.HeaderNameMapper;
import net.sf.testng.databinding.util.Exceptions;
import net.sf.testng.databinding.util.MethodParameter;

public class HeaderNameFileLinkingMapper
extends HeaderNameMapper {
    private final String linkingColumnPrefix;

    public HeaderNameFileLinkingMapper(List<MethodParameter> parameters, Properties properties) {
        super(parameters, properties);
        this.linkingColumnPrefix = properties.getProperty("linkingColumnPrefix", "link_");
    }

    @Override
    protected List<ErrorCollector> checkParameters(List<MethodParameter> parameters) {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        for (MethodParameter parameter : parameters) {
            Type type = parameter.getType();
            ErrorCollector errorCollector = new ErrorCollector(type);
            this.checkIsNotEnumType(type, errorCollector);
            if (!errorCollector.hasErrors()) continue;
            errorCollectors.add(errorCollector);
        }
        return errorCollectors;
    }

    @Override
    protected List<ErrorCollector> checkHeaders() throws Exception {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        errorCollectors.addAll(this.checkInputHeaders());
        errorCollectors.addAll(this.checkOutputHeaders());
        return errorCollectors;
    }

    private List<ErrorCollector> checkInputHeaders() throws IntrospectionException {
        return this.checkHeaders(this.getInputParameters(), this.getInputColumnPrefix());
    }

    private List<ErrorCollector> checkOutputHeaders() throws IntrospectionException {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        String prefix = this.getOutputColumnPrefix();
        for (MethodParameter parameter : this.getOutputParameters()) {
            Type type = parameter.getType();
            ErrorCollector errorCollector = null;
            if (Types.isPrimitiveType((Type)type)) {
                errorCollector = this.checkPrimitiveTypeHeaders(type, parameter.getName(), prefix);
            } else if (Types.isSingleBeanType((Type)type)) {
                errorCollector = this.checkSingleBeanHeaders((Class)type, prefix);
            } else if (Types.isListOfPrimitivesType((Type)type)) {
                errorCollector = this.checkListOfPrimitivesHeaders(type, parameter.getName(), prefix);
            } else if (Types.isListOfBeansType((Type)type)) {
                errorCollector = this.checkListOfBeansHeaders((ParameterizedType)type, prefix);
            }
            if (errorCollector == null || !errorCollector.hasErrors()) continue;
            errorCollectors.add(errorCollector);
        }
        return errorCollectors;
    }

    private ErrorCollector checkListOfPrimitivesHeaders(Type type, String name, String prefix) {
        ErrorCollector errorCollector = new ErrorCollector(type, name);
        if (!this.headersContain(this.linkingColumnPrefix, name)) {
            errorCollector.addError("no link column found");
        }
        return errorCollector;
    }

    private ErrorCollector checkListOfBeansHeaders(ParameterizedType type, String prefix) {
        ErrorCollector errorCollector = new ErrorCollector((Type)type);
        Class beanClass = (Class)type.getActualTypeArguments()[0];
        if (!this.headersContain(this.linkingColumnPrefix, beanClass.getSimpleName())) {
            errorCollector.addError("no link column found");
        }
        return errorCollector;
    }

    @Override
    public Object[] createBeans(String[] line) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (MethodParameter parameter : this.getParameters()) {
            if (this.getInputParameters().contains(parameter)) {
                objects.add(this.createInputObject(parameter, line));
                continue;
            }
            if (!this.getOutputParameters().contains(parameter)) continue;
            objects.add(this.createOutputObject(parameter, line));
        }
        return objects.toArray();
    }

    private Object createInputObject(MethodParameter parameter, String[] line) {
        return this.createObject(parameter, line, this.getInputColumnPrefix());
    }

    private Object createOutputObject(MethodParameter parameter, String[] line) {
        Type type = parameter.getType();
        if (Types.isListOfObjectsType((Type)type)) {
            return this.createListOfObjects(parameter, line);
        }
        return this.createObject(parameter, line, this.getOutputColumnPrefix());
    }

    private Object createListOfObjects(MethodParameter parameter, String[] line) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            String name = parameter.getName();
            String link = line[this.getHeaderIndexFor(this.linkingColumnPrefix, name)];
            Properties properties = this.copyProperties();
            this.setLinkUrl(properties, link);
            List<MethodParameter> parameters = this.createParameters(parameter);
            CsvDataSource provider = new CsvDataSource(parameters, properties);
            while (provider.hasNext()) {
                list.add(provider.next()[0]);
            }
            return list;
        }
        catch (Exception e) {
            throw Exceptions.softenIfNecessary((Exception)e);
        }
    }

    private Properties copyProperties() {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    private void setLinkUrl(Properties properties, String link) {
        String linkUrl = this.resolveUrl(properties.getProperty("url"), link);
        properties.setProperty("url", linkUrl);
    }

    private String resolveUrl(String url, String link) {
        String urlBase = url.substring(0, url.lastIndexOf("/"));
        return urlBase + "/" + link;
    }

    private List<MethodParameter> createParameters(MethodParameter parameter) {
        return Arrays.asList(Types.unwrapIfPossible((MethodParameter)parameter));
    }
}

