/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sf.testng.databinding.TestInput;
import net.sf.testng.databinding.TestOutput;
import net.sf.testng.databinding.core.error.ErrorCollector;
import net.sf.testng.databinding.core.error.MultipleSourceErrorsException;
import net.sf.testng.databinding.core.util.Types;
import net.sf.testng.databinding.csv.Mapper;
import net.sf.testng.databinding.util.Exceptions;
import net.sf.testng.databinding.util.MethodParameter;

public class HeaderNameMapper
extends Mapper {
    private String inputColumnPrefix;
    private String outputColumnPrefix;
    private List<String> headers = new ArrayList<String>();
    private List<MethodParameter> inputParameters = new ArrayList<MethodParameter>();
    private List<MethodParameter> outputParameters = new ArrayList<MethodParameter>();

    public HeaderNameMapper(List<MethodParameter> parameters, Properties properties) {
        super(parameters, properties);
        this.inputColumnPrefix = properties.getProperty("inputColumnPrefix", "in_");
        this.outputColumnPrefix = properties.getProperty("outputColumnPrefix", "out_");
        for (MethodParameter parameter : parameters) {
            if (parameter.getAnnotation(TestInput.class) != null) {
                this.inputParameters.add(parameter);
                continue;
            }
            if (parameter.getAnnotation(TestOutput.class) == null) continue;
            this.outputParameters.add(parameter);
        }
    }

    protected final String getInputColumnPrefix() {
        return this.inputColumnPrefix;
    }

    protected final String getOutputColumnPrefix() {
        return this.outputColumnPrefix;
    }

    protected final List<MethodParameter> getInputParameters() {
        return this.inputParameters;
    }

    protected final List<MethodParameter> getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    protected List<ErrorCollector> checkParameters(List<MethodParameter> parameters) {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        for (MethodParameter parameter : parameters) {
            Type type = parameter.getType();
            if (!Types.isEnumType((Type)type) && !Types.isListOfObjectsType((Type)type)) continue;
            ErrorCollector errorCollector = new ErrorCollector(type);
            errorCollector.addError("Type " + type + " is not supported by this mapper: " + this.getClass());
            errorCollectors.add(errorCollector);
        }
        return errorCollectors;
    }

    @Override
    public void init(CSVReader csvReader) throws Exception {
        String[] headerLine = csvReader.readNext();
        this.headers.addAll(Arrays.asList(headerLine));
        this.normalizeHeaders();
        List<ErrorCollector> errorCollectors = this.checkHeaders();
        if (errorCollectors != null && errorCollectors.size() > 0) {
            throw new MultipleSourceErrorsException(errorCollectors);
        }
    }

    private void normalizeHeaders() {
        ArrayList<String> normalizedHeaders = new ArrayList<String>();
        for (String header : this.headers) {
            normalizedHeaders.add(header.toLowerCase());
        }
        this.headers = normalizedHeaders;
    }

    protected List<ErrorCollector> checkHeaders() throws Exception {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        errorCollectors.addAll(this.checkHeaders(this.inputParameters, this.inputColumnPrefix));
        errorCollectors.addAll(this.checkHeaders(this.outputParameters, this.outputColumnPrefix));
        return errorCollectors;
    }

    protected List<ErrorCollector> checkHeaders(List<MethodParameter> parameters, String prefix) throws IntrospectionException {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        for (MethodParameter parameter : parameters) {
            Type type = parameter.getType();
            ErrorCollector errorCollector = null;
            if (Types.isPrimitiveType((Type)type)) {
                String name = parameter.getName();
                errorCollector = this.checkPrimitiveTypeHeaders(type, name, prefix);
            } else if (Types.isSingleBeanType((Type)type)) {
                errorCollector = this.checkSingleBeanHeaders((Class)type, prefix);
            }
            if (errorCollector == null || !errorCollector.hasErrors()) continue;
            errorCollectors.add(errorCollector);
        }
        return errorCollectors;
    }

    protected ErrorCollector checkPrimitiveTypeHeaders(Type type, String name, String prefix) {
        ErrorCollector errorCollector = new ErrorCollector(type, name);
        if (!this.headersContain(prefix, name)) {
            errorCollector.addError("header not found: " + prefix + name);
        }
        return errorCollector;
    }

    protected ErrorCollector checkSingleBeanHeaders(Class<?> type, String prefix) throws IntrospectionException {
        ErrorCollector errorCollector = new ErrorCollector(type);
        BeanInfo info = Introspector.getBeanInfo(type);
        for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
            if (!this.isWriteable(descriptor) || this.headersContain(prefix, descriptor.getName())) continue;
            errorCollector.addError("header not found: " + prefix + descriptor.getName());
        }
        return errorCollector;
    }

    private boolean isWriteable(PropertyDescriptor descriptor) {
        return descriptor.getWriteMethod() != null;
    }

    protected boolean headersContain(String prefix, String name) {
        return this.headers.contains(this.createHeader(prefix, name));
    }

    private String createHeader(String prefix, String name) {
        return (prefix + name).toLowerCase();
    }

    @Override
    public Object[] createBeans(String[] line) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (MethodParameter parameter : this.getParameters()) {
            if (this.inputParameters.contains(parameter)) {
                objects.add(this.createObject(parameter, line, this.inputColumnPrefix));
                continue;
            }
            if (!this.outputParameters.contains(parameter)) continue;
            objects.add(this.createObject(parameter, line, this.outputColumnPrefix));
        }
        return objects.toArray();
    }

    protected Object createObject(MethodParameter parameter, String[] line, String prefix) {
        Type type = parameter.getType();
        if (Types.isPrimitiveType((Type)type)) {
            return this.createPrimitive(parameter, line, prefix);
        }
        if (Types.isSingleBeanType((Type)type)) {
            return this.createSingleBean(parameter, line, prefix);
        }
        return null;
    }

    protected Object createPrimitive(MethodParameter parameter, String[] line, String prefix) {
        String value = line[this.getHeaderIndexFor(prefix, parameter.getName())];
        Type type = parameter.getType();
        if (type.equals(String.class)) {
            return value;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        throw new RuntimeException();
    }

    protected Object createSingleBean(MethodParameter parameter, String[] line, String prefix) {
        try {
            Class clazz = (Class)parameter.getType();
            Object object = clazz.newInstance();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                if (!this.isWriteable(descriptor) || !this.isPrimitiveType(descriptor)) continue;
                Object value = this.createPrimitive(this.createMethodParameterForProperty(descriptor), line, prefix);
                Method writeMethod = descriptor.getWriteMethod();
                writeMethod.invoke(object, value);
            }
            return object;
        }
        catch (Exception e) {
            throw Exceptions.softenIfNecessary((Exception)e);
        }
    }

    private boolean isPrimitiveType(PropertyDescriptor descriptor) {
        return Types.isPrimitiveType(descriptor.getPropertyType());
    }

    private MethodParameter createMethodParameterForProperty(PropertyDescriptor descriptor) {
        Method writeMethod = descriptor.getWriteMethod();
        Annotation[][] annotations = writeMethod.getParameterAnnotations();
        Type[] parameterTypes = writeMethod.getGenericParameterTypes();
        return new MethodParameter(Arrays.asList(annotations[0]), parameterTypes[0], descriptor.getName());
    }

    protected int getHeaderIndexFor(String prefix, String name) {
        return this.headers.indexOf((prefix + name).toLowerCase());
    }
}

