/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.testng.databinding.AbstractDataSource;
import net.sf.testng.databinding.DataSource;
import net.sf.testng.databinding.TestInput;
import net.sf.testng.databinding.TestOutput;
import net.sf.testng.databinding.core.error.ErrorCollector;
import net.sf.testng.databinding.core.error.MissingPropertiesException;
import net.sf.testng.databinding.core.error.MultipleConfigurationErrorsException;
import net.sf.testng.databinding.core.error.MultipleSourceErrorsException;
import net.sf.testng.databinding.core.util.Types;
import net.sf.testng.databinding.util.Exceptions;
import net.sf.testng.databinding.util.MethodParameter;

@DataSource(name="xml")
public class XMLDataSource
extends AbstractDataSource {
    private static final String TEST_INPUT_DATA_TAG = "testInputData";
    private static final String TEST_OUTPUT_DATA_TAG = "testOutputData";
    private static final String DATA_SET_TAG = "dataSet";
    private static final String ROOT_TAG = "testData";
    private final List<MethodParameter> inputParameters = new ArrayList<MethodParameter>();
    private final List<MethodParameter> outputParameters = new ArrayList<MethodParameter>();
    private final XMLStreamReader xmlReader;
    private final Properties properties;
    private InputStream urlStream;
    private List<MethodParameter> parameters;
    private boolean usesDataSetTag;
    private boolean hasNext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLDataSource(List<MethodParameter> parameters, Properties properties) throws Exception {
        boolean cleanUpNecessary = true;
        try {
            this.checkProperties(properties);
            this.properties = properties;
            this.setParameters(parameters);
            this.xmlReader = this.createXmlReader();
            this.checkDataSource();
            cleanUpNecessary = false;
        }
        finally {
            if (cleanUpNecessary) {
                this.cleanUp();
            }
        }
    }

    private void checkProperties(Properties properties) {
        ArrayList<String> missingKeys = new ArrayList<String>();
        if (!properties.containsKey("url")) {
            missingKeys.add("url");
        }
        if (missingKeys.size() > 0) {
            throw new MissingPropertiesException(missingKeys);
        }
    }

    private XMLStreamReader createXmlReader() throws Exception {
        URL url = this.resolveUrl(this.properties.getProperty("url"));
        this.urlStream = url.openStream();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = factory.createXMLStreamReader(this.urlStream, this.properties.getProperty("encoding", "UTF-8"));
        return xmlReader;
    }

    private URL resolveUrl(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            url = ((Object)((Object)this)).getClass().getResource(urlString);
        }
        return url;
    }

    private void checkDataSource() {
        boolean validDataSource;
        try {
            if (this.xmlReader.next() == 1 && this.xmlReader.getLocalName().equals(ROOT_TAG) && this.xmlReader.getAttributeCount() == 0 && this.xmlReader.nextTag() == 1 && this.isExpectedBeginOfDataSetTag(this.xmlReader.getLocalName(), true)) {
                validDataSource = true;
                this.hasNext = true;
            } else {
                validDataSource = false;
            }
        }
        catch (Throwable t) {
            validDataSource = false;
        }
        if (!validDataSource) {
            throw this.genericSourceErrorsException(null);
        }
    }

    private boolean isExpectedBeginOfDataSetTag(String tagName, boolean dataSetAllowed) throws XMLStreamException {
        if (dataSetAllowed && tagName.equals(DATA_SET_TAG) && this.xmlReader.nextTag() == 1) {
            this.usesDataSetTag = true;
            return this.isExpectedBeginOfDataSetTag(this.xmlReader.getLocalName(), false);
        }
        return this.inputParameters.size() > 0 && tagName.equals(TEST_INPUT_DATA_TAG) || this.inputParameters.size() == 0 && this.outputParameters.size() > 0 && tagName.equals(TEST_OUTPUT_DATA_TAG);
    }

    private void setParameters(List<MethodParameter> parameters) {
        this.parameters = parameters;
        for (MethodParameter parameter : parameters) {
            if (parameter.getAnnotation(TestInput.class) != null) {
                this.inputParameters.add(parameter);
                continue;
            }
            if (parameter.getAnnotation(TestOutput.class) == null) continue;
            this.outputParameters.add(parameter);
        }
        if (this.inputParameters.isEmpty() && this.outputParameters.isEmpty()) {
            ErrorCollector errorCollector = new ErrorCollector("method parameters");
            errorCollector.addError("no parameters with @TestInput or @TestOutput annotation given");
            throw new MultipleConfigurationErrorsException(Arrays.asList(errorCollector));
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object[] next() {
        if (this.hasNext) {
            boolean cleanUpNecessary = true;
            try {
                Object[] nextDataSet = this.createNextDataSet(this.xmlReader);
                cleanUpNecessary = false;
                Object[] objectArray = nextDataSet;
                return objectArray;
            }
            catch (MultipleConfigurationErrorsException e) {
                throw e;
            }
            catch (MultipleSourceErrorsException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.genericSourceErrorsException(e.getClass().getName() + ": " + e.getMessage());
            }
            finally {
                if (cleanUpNecessary) {
                    this.cleanUp();
                }
            }
        }
        throw new NoSuchElementException();
    }

    private Object[] createNextDataSet(XMLStreamReader xmlReader) throws XMLStreamException {
        HashMap<MethodParameter, Object> objects = new HashMap<MethodParameter, Object>();
        if (this.inputParameters.size() > 0) {
            this.findOpeningTag(TEST_INPUT_DATA_TAG, this.getSectionTagName(), xmlReader);
            objects.putAll(this.createNextInputData(xmlReader));
        }
        if (this.outputParameters.size() > 0) {
            this.findOpeningTag(TEST_OUTPUT_DATA_TAG, this.getSectionTagName(), xmlReader);
            objects.putAll(this.createNextOutputData(xmlReader));
        }
        this.hasNext = this.determineHasNext(xmlReader);
        return this.orderAndConvert(objects);
    }

    private Map<MethodParameter, Object> createNextInputData(XMLStreamReader xmlReader) throws XMLStreamException {
        return this.createNextData(xmlReader, this.inputParameters, TEST_INPUT_DATA_TAG);
    }

    private Map<MethodParameter, Object> createNextOutputData(XMLStreamReader xmlReader) throws XMLStreamException {
        return this.createNextData(xmlReader, this.outputParameters, TEST_OUTPUT_DATA_TAG);
    }

    private Map<MethodParameter, Object> createNextData(XMLStreamReader xmlReader, List<MethodParameter> parameters, String sectionTagName) throws XMLStreamException {
        ArrayList<MethodParameter> remainingParameters = new ArrayList<MethodParameter>(parameters);
        HashMap<MethodParameter, Object> objects = new HashMap<MethodParameter, Object>();
        xmlReader.next();
        while (!this.reachedEndOfDataSection(sectionTagName, xmlReader.getEventType(), xmlReader)) {
            if (xmlReader.getEventType() == 1) {
                String tagName = xmlReader.getLocalName();
                MethodParameter parameter = this.getMethodParameterByName(remainingParameters, tagName);
                if (parameter != null) {
                    objects.put(parameter, this.processMethodParameter(parameter, xmlReader));
                    remainingParameters.remove(parameter);
                } else {
                    this.skipToEndTag(tagName, xmlReader);
                }
            }
            this.parseNextInDataSectionIfNecessary(sectionTagName, xmlReader);
        }
        if (remainingParameters.isEmpty()) {
            return objects;
        }
        throw this.remainingParametersSourceErrorsException(remainingParameters);
    }

    private boolean reachedEndOfDataSection(String sectionTagName, int event, XMLStreamReader xmlReader) {
        return event == 2 && xmlReader.getLocalName().equals(sectionTagName);
    }

    private void parseNextInDataSectionIfNecessary(String sectionTagName, XMLStreamReader xmlReader) throws XMLStreamException {
        int event = xmlReader.getEventType();
        if (event != 1 && !this.reachedEndOfDataSection(sectionTagName, event, xmlReader) || event == 1 && xmlReader.getLocalName().equals(sectionTagName)) {
            xmlReader.next();
        }
    }

    private Object processMethodParameter(MethodParameter parameter, XMLStreamReader xmlReader) throws XMLStreamException {
        Type type = parameter.getType();
        if (Types.isEnumType((Type)type)) {
            return this.processEnumParameter(parameter, xmlReader);
        }
        if (Types.isPrimitiveType((Type)type)) {
            return this.processPrimitiveParameter(parameter, xmlReader);
        }
        if (Types.isSingleBeanType((Type)type)) {
            return this.processSingleBeanParameter(parameter, xmlReader);
        }
        if (Types.isListOfPrimitivesType((Type)type)) {
            return this.processListOfPrimitivesParameter(parameter, xmlReader);
        }
        if (Types.isListOfBeansType((Type)type)) {
            return this.processListOfBeansParameter(parameter, xmlReader);
        }
        ErrorCollector errorCollector = new ErrorCollector(type, parameter.getName());
        errorCollector.addError("unsupported type for data source " + ((Object)((Object)this)).getClass().getSimpleName());
        throw new MultipleConfigurationErrorsException(Arrays.asList(errorCollector));
    }

    private Object processEnumParameter(MethodParameter parameter, XMLStreamReader xmlReader) throws XMLStreamException {
        Field[] fields;
        String enumName = xmlReader.getElementText();
        Class enumClass = (Class)parameter.getType();
        for (Field field : fields = enumClass.getFields()) {
            try {
                if (!field.getName().equals(enumName)) continue;
                return field.get(null);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        ErrorCollector errorCollector = new ErrorCollector(parameter.getType(), parameter.getName());
        errorCollector.addError("the value [" + enumName + "] found in the source isn't a member of this enum type");
        throw new MultipleSourceErrorsException(Arrays.asList(errorCollector));
    }

    private Object processPrimitiveParameter(MethodParameter parameter, XMLStreamReader xmlReader) throws XMLStreamException {
        String value = xmlReader.getElementText();
        Type type = parameter.getType();
        if (type.equals(String.class)) {
            return value;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        throw new RuntimeException();
    }

    private Object processListOfPrimitivesParameter(MethodParameter listParameter, XMLStreamReader xmlReader) throws XMLStreamException {
        MethodParameter valueParameter = this.deriveValueFromListParameter(listParameter);
        ArrayList<Object> primitives = new ArrayList<Object>();
        do {
            primitives.add(this.processPrimitiveParameter(valueParameter, xmlReader));
            xmlReader.nextTag();
        } while (xmlReader.getEventType() == 1 && this.nameMatches(listParameter.getType(), listParameter.getName(), xmlReader.getLocalName()));
        return primitives;
    }

    private Object processSingleBeanParameter(MethodParameter parameter, XMLStreamReader xmlReader) throws XMLStreamException {
        try {
            String beanName = parameter.getName();
            Class clazz = (Class)parameter.getType();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            List<PropertyDescriptor> remainingCandidates = this.filterCandidateProperties(info.getPropertyDescriptors());
            Object bean = clazz.newInstance();
            xmlReader.next();
            while (!this.reachedEndOfBeanSection(clazz, beanName, xmlReader)) {
                if (xmlReader.getEventType() == 1) {
                    String tagName = xmlReader.getLocalName();
                    PropertyDescriptor descriptor = this.getPropertyDescriptorByName(remainingCandidates, tagName);
                    if (descriptor != null) {
                        descriptor.getWriteMethod().invoke(bean, this.processMethodParameter(this.createMethodParameterForProperty(descriptor), xmlReader));
                        remainingCandidates.remove(descriptor);
                    } else {
                        this.skipToEndTag(tagName, xmlReader);
                    }
                }
                this.parseNextInBeanIfNecessary(clazz, beanName, xmlReader);
            }
            return bean;
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (Exception e) {
            ErrorCollector errorCollector = new ErrorCollector(parameter.getType());
            errorCollector.addError("unable to create type: " + e.getMessage());
            throw new MultipleConfigurationErrorsException(Arrays.asList(errorCollector));
        }
    }

    private void skipToEndTag(String tagName, XMLStreamReader xmlReader) throws XMLStreamException {
        while (xmlReader.getEventType() != 2 || !xmlReader.getLocalName().equals(tagName)) {
            if (xmlReader.hasNext()) {
                xmlReader.next();
                continue;
            }
            throw this.genericSourceErrorsException("unexpected end of document encountered while skipping to closing tag </" + tagName + ">");
        }
    }

    private boolean reachedEndOfBeanSection(Class<?> beanType, String beanName, XMLStreamReader xmlReader) {
        return xmlReader.getEventType() == 2 && this.nameMatches(beanType, beanName, xmlReader.getLocalName());
    }

    private void parseNextInBeanIfNecessary(Class<?> beanType, String beanName, XMLStreamReader xmlReader) throws XMLStreamException {
        if (xmlReader.getEventType() != 1 && !this.reachedEndOfBeanSection(beanType, beanName, xmlReader)) {
            xmlReader.next();
        }
    }

    private List<PropertyDescriptor> filterCandidateProperties(PropertyDescriptor[] descriptors) {
        ArrayList<PropertyDescriptor> candidates = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getWriteMethod() == null) continue;
            candidates.add(descriptor);
        }
        return candidates;
    }

    private PropertyDescriptor getPropertyDescriptorByName(List<PropertyDescriptor> descriptors, String tagName) {
        for (PropertyDescriptor descriptor : descriptors) {
            Type propertyType = descriptor.getWriteMethod().getGenericParameterTypes()[0];
            if (!this.nameMatches(propertyType, descriptor.getName(), tagName)) continue;
            return descriptor;
        }
        return null;
    }

    private MethodParameter createMethodParameterForProperty(PropertyDescriptor descriptor) {
        Method writeMethod = descriptor.getWriteMethod();
        Annotation[][] annotations = writeMethod.getParameterAnnotations();
        Type[] parameterTypes = writeMethod.getGenericParameterTypes();
        return new MethodParameter(Arrays.asList(annotations[0]), parameterTypes[0], descriptor.getName());
    }

    private Object processListOfBeansParameter(MethodParameter listParameter, XMLStreamReader xmlReader) throws XMLStreamException {
        MethodParameter valueParameter = this.deriveValueFromListParameter(listParameter);
        ArrayList<Object> beans = new ArrayList<Object>();
        do {
            beans.add(this.processSingleBeanParameter(valueParameter, xmlReader));
            xmlReader.nextTag();
        } while (xmlReader.getEventType() == 1 && this.nameMatches(listParameter.getType(), listParameter.getName(), xmlReader.getLocalName()));
        return beans;
    }

    private MethodParameter deriveValueFromListParameter(MethodParameter listParameter) {
        MethodParameter valueParameter = Types.unwrapIfPossible((MethodParameter)listParameter);
        String listParameterName = listParameter.getName();
        String name = null;
        name = listParameterName.endsWith("ies") ? listParameterName.substring(0, listParameterName.length() - "ies".length()) + "y" : listParameterName.substring(0, listParameterName.length() - 1);
        return new MethodParameter(valueParameter.getAnnotations(), valueParameter.getType(), name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean determineHasNext(XMLStreamReader xmlReader) throws XMLStreamException {
        Boolean hasNext = null;
        if (this.usesDataSetTag) {
            while (xmlReader.getEventType() != 1) {
                if (xmlReader.hasNext()) {
                    xmlReader.next();
                    continue;
                }
                hasNext = false;
                break;
            }
            if (hasNext == null) {
                String tagName = xmlReader.getLocalName();
                if (!tagName.equals(DATA_SET_TAG)) throw this.genericSourceErrorsException("expected opening tag <dataSet> or end of file, but found opening tag <" + tagName + ">");
                hasNext = true;
            }
        } else {
            hasNext = false;
        }
        if (hasNext.booleanValue()) return hasNext;
        this.cleanUp();
        return hasNext;
    }

    private void cleanUp() {
        try {
            if (this.xmlReader != null) {
                this.xmlReader.close();
            }
            if (this.urlStream != null) {
                this.urlStream.close();
            }
        }
        catch (Exception e) {
            throw Exceptions.softenIfNecessary((Exception)e);
        }
    }

    private Object[] orderAndConvert(Map<MethodParameter, Object> objectsMap) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (MethodParameter parameter : this.parameters) {
            objects.add(objectsMap.get(parameter));
        }
        return objects.toArray();
    }

    private MethodParameter getMethodParameterByName(List<MethodParameter> parameters, String name) {
        for (MethodParameter parameter : parameters) {
            if (!this.nameMatches(parameter.getType(), parameter.getName(), name)) continue;
            return parameter;
        }
        return null;
    }

    private boolean nameMatches(Type namedType, String typeName, String tagName) {
        String normalizedTypeName = typeName.toLowerCase();
        String normalizedTagName = tagName.toLowerCase();
        if (Types.isSingleObjectType((Type)namedType) && normalizedTypeName.equals(normalizedTagName)) {
            return true;
        }
        if (Types.isListOfObjectsType((Type)namedType)) {
            if (normalizedTypeName.equals(normalizedTagName + "s")) {
                return true;
            }
            if (normalizedTypeName.endsWith("ies") && normalizedTagName.endsWith("y")) {
                String typeNameBody = normalizedTypeName.substring(0, normalizedTypeName.length() - "ies".length());
                String tagNameBody = normalizedTagName.substring(0, normalizedTagName.length() - "y".length());
                return typeNameBody.equals(tagNameBody);
            }
        }
        return false;
    }

    private String getSectionTagName() {
        return this.usesDataSetTag ? DATA_SET_TAG : ROOT_TAG;
    }

    private void findOpeningTag(String tagName, String sectionTagName, XMLStreamReader xmlReader) throws XMLStreamException {
        if (xmlReader.getEventType() == 1 && xmlReader.getLocalName().equals(tagName)) {
            return;
        }
        int event = xmlReader.next();
        while (xmlReader.hasNext()) {
            if (event == 1 && xmlReader.getLocalName().equals(tagName)) {
                return;
            }
            if (event == 2 && xmlReader.getLocalName().equals(sectionTagName)) {
                throw this.genericSourceErrorsException("couldn't find tag <" + tagName + "> within section <" + sectionTagName + ">");
            }
            event = xmlReader.next();
        }
        throw this.genericSourceErrorsException("couldn't find end tag </" + sectionTagName + "> - source is malformed!");
    }

    private MultipleSourceErrorsException genericSourceErrorsException(String detailMessage) {
        Location location = this.xmlReader.getLocation();
        ErrorCollector errorCollector = new ErrorCollector(this.properties.getProperty("url"));
        errorCollector.addError("invalid source for data provider strategy " + ((Object)((Object)this)).getClass().getName() + " at [" + location.getLineNumber() + ":" + location.getColumnNumber() + "]" + ", current parse event: " + this.eventCodeToText(this.xmlReader.getEventType()) + (detailMessage != null ? ", detail message: " + detailMessage : ""));
        return new MultipleSourceErrorsException(Arrays.asList(errorCollector));
    }

    private MultipleSourceErrorsException remainingParametersSourceErrorsException(List<MethodParameter> remainingParameters) {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        for (MethodParameter parameter : remainingParameters) {
            ErrorCollector errorCollector = new ErrorCollector(parameter.getType(), parameter.getName());
            errorCollector.addError("no data found for this parameter");
            errorCollectors.add(errorCollector);
        }
        return new MultipleSourceErrorsException(errorCollectors);
    }

    private String eventCodeToText(int event) {
        switch (event) {
            case 10: {
                return "attribute";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "characters";
            }
            case 5: {
                return "comment";
            }
            case 11: {
                return "dtd definition";
            }
            case 8: {
                return "end of document";
            }
            case 2: {
                return "closing tag";
            }
            case 15: {
                return "dtd entity declaration";
            }
            case 9: {
                return "dtd entity reference";
            }
            case 13: {
                return "namespace";
            }
            case 14: {
                return "notation declaration";
            }
            case 3: {
                return "processing instruction";
            }
            case 6: {
                return "whitespace";
            }
            case 7: {
                return "begin of document";
            }
            case 1: {
                return "opening tag";
            }
        }
        return "unknown xml parse event";
    }
}

