/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.xsltmp.FromManyBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ManyToOneMojo
extends FromManyBase {
    private File srcFile;
    private File destFile;
    private boolean shouldRun = false;
    private File resolvedSrcFile;
    public static final String SOURCE_FILE_NAMES_SEPARATOR = "|";

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public boolean getShouldRun() {
        return this.shouldRun;
    }

    public File getResolvedSrcFile() {
        return this.resolvedSrcFile;
    }

    protected String getMojoName() {
        return "many-to-one";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Object sourceFileNames;
            if (!this.verifyXsltFileExist()) {
                return;
            }
            if (!this.verifySrcDirExist()) {
                return;
            }
            this.ensureDestFileDirExists(this.getDestFile());
            this.prepare();
            if (!this.doesSrcFileExists()) {
                this.getLog().info((CharSequence)"Source file does not exist, using default.");
            }
            if (!"".equals(sourceFileNames = this.getParameters().get("source-file-names"))) {
                this.getLog().info((CharSequence)("Stored source-file-names param: " + sourceFileNames));
            }
            if (this.shouldRun) {
                this.logExecution(this.getSrcFile());
                this.getTransformer().transform(new StreamSource(this.resolvedSrcFile), new StreamResult(this.getDestFile()));
            } else {
                this.getLog().info((CharSequence)"No sources to process.");
            }
        }
        catch (MojoFailureException mfe) {
            throw mfe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void prepare() throws MojoFailureException {
        this.storeSourceFileNamesInParam();
        if (this.doesSrcFileExists()) {
            this.resolvedSrcFile = this.getSrcFile();
            this.shouldRun |= this.hasChanged(this.resolvedSrcFile);
        } else {
            this.resolvedSrcFile = this.getDefaultFile();
        }
    }

    private File getDefaultFile() throws MojoFailureException {
        File defaultDestDir = new File(this.getProject().getBuild().getDirectory(), "generated-xml/xslt-generator-maven-plugin");
        File empty = new File(defaultDestDir, "empty.xml");
        if (!empty.exists()) {
            this.createDefaultFile(empty);
        }
        return empty;
    }

    private void createDefaultFile(File file) throws MojoFailureException {
        file.getParentFile().mkdirs();
        try {
            FileWriter w = new FileWriter(file);
            w.write("<root/>");
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException("Cannot create default source, " + e.getMessage(), (Throwable)e);
        }
    }

    private void storeSourceFileNamesInParam() throws MojoFailureException {
        try {
            boolean xslFileChanged = this.hasChanged(this.getXslFile());
            String srcDirPath = this.getSrcDir().getCanonicalPath();
            StringBuilder b = new StringBuilder();
            String[] sourceFileNames = this.getSourceFiles();
            for (int i = 0; i < sourceFileNames.length; ++i) {
                File srcFile = this.getSourceFile(sourceFileNames[i]);
                if (!xslFileChanged && !this.hasChanged(srcFile)) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("File skipped: " + srcFile));
                    continue;
                }
                this.shouldRun = true;
                String srcFilePath = srcFile.getCanonicalPath();
                if (!srcFilePath.startsWith(srcDirPath)) {
                    throw new MojoFailureException("Source file not within source directory: " + srcFilePath);
                }
                srcFilePath = srcFilePath.substring(srcDirPath.length() + 1).replace('\\', '/');
                b.append(srcFilePath);
                b.append(SOURCE_FILE_NAMES_SEPARATOR);
            }
            String names = b.toString();
            if (names.endsWith(SOURCE_FILE_NAMES_SEPARATOR)) {
                names = names.substring(0, names.length() - 1);
            }
            this.getParameters().put("source-file-names", names);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException("Cannot read canonical file path", (Throwable)e);
        }
    }

    private boolean doesSrcFileExists() {
        return null != this.getSrcFile() && this.getSrcFile().exists();
    }
}

