/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class AddSourcesUtils {
    private final MavenProject project;
    private final Log log;

    public AddSourcesUtils(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    public void addSources(String addTo, File dir) {
        String path = dir.getAbsolutePath();
        if ("sources".equals(addTo)) {
            this.project.addCompileSourceRoot(path);
            this.log.info((CharSequence)("Added to " + addTo + " destDir: " + path));
        }
        if ("test-sources".equals(addTo)) {
            this.project.addTestCompileSourceRoot(path);
            this.log.info((CharSequence)("Added to " + addTo + " destDir: " + path));
        }
    }

    public void addResources(String addTo, File dir) {
        String path = dir.getAbsolutePath();
        if ("resources".equals(addTo)) {
            this.project.addResource(this.getDirResource(dir));
            this.log.info((CharSequence)("Added to " + addTo + " destDir: " + path));
        }
        if ("test-resources".equals(addTo)) {
            this.project.addTestResource(this.getDirResource(dir));
            this.log.info((CharSequence)("Added to " + addTo + " destDir: " + path));
        }
    }

    private Resource getDirResource(File dir) {
        Resource resource = new Resource();
        resource.setDirectory(dir.getAbsolutePath());
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/*.java");
        resource.setExcludes(excludes);
        return resource;
    }
}

