/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.xsltmp.XsltGeneratorConstants;
import net.sf.xsltmp.filter.Filter;
import net.sf.xsltmp.util.FileCache;
import net.sf.xsltmp.util.FileResolver;
import net.sf.xsltmp.util.UnArchiverHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class DefaultURIResolver
extends FileResolver
implements URIResolver,
XsltGeneratorConstants {
    private final String sourceEncoding;
    private final String filterType;
    private final Map filterParameters;
    private final FileCache filteredContent;
    private Filter filter;

    public DefaultURIResolver(Log log, MavenProject project, UnArchiverHelper helper, String sourceEncoding, String filter, Map filterParameters) {
        super(log, project, helper);
        this.sourceEncoding = sourceEncoding;
        this.filterType = filter;
        this.filterParameters = filterParameters;
        File buildBase = new File(this.getProject().getBuild().getDirectory());
        File filteredBase = new File(buildBase, "xslt-generator-maven-plugin/filtered");
        this.filteredContent = new FileCache(log, buildBase, filteredBase, sourceEncoding);
    }

    public Source resolve(String href, String base) throws TransformerConfigurationException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolving: " + href + " at base: " + base));
        }
        File result = null;
        try {
            File baseFile = new File(new URI(base));
            result = new File(baseFile.getParentFile(), href);
        }
        catch (URISyntaxException e) {
            this.getLog().warn((CharSequence)("Unable to parse URI: " + base));
        }
        if (!this.exists(result)) {
            result = this.resolve(href);
        }
        if (result.exists()) {
            return this.createSource(result);
        }
        return null;
    }

    protected Source createSource(File file) throws TransformerConfigurationException {
        try {
            Reader reader = new InputStreamReader((InputStream)new FileInputStream(file), this.sourceEncoding);
            reader = this.wrapInFilter(reader, file);
            StreamSource source = new StreamSource(reader);
            source.setSystemId(file);
            return source;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            throw new TransformerConfigurationException("File not found: " + file, fnfe);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new TransformerConfigurationException("Unsupported source encoding: " + this.sourceEncoding, uee);
        }
    }

    private Reader wrapInFilter(Reader reader, File file) throws TransformerConfigurationException {
        if (null != this.filterType) {
            if (this.isTemplate(file)) {
                Reader cached = this.filteredContent.retrieve(file);
                if (null != cached) {
                    return cached;
                }
                reader = this.performFiltering(reader, file);
                this.filteredContent.store(reader, file);
            } else if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("File not filtered, not a template: " + file));
            }
        }
        return reader;
    }

    private boolean isTemplate(File file) {
        return file.getName().endsWith(".xsl");
    }

    private Reader performFiltering(Reader reader, File file) throws TransformerConfigurationException {
        try {
            if (null == this.filter) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Initializing filter: " + this.filterType));
                }
                this.filter = (Filter)Class.forName(this.filterType).newInstance();
                this.filter.setMavenProject(this.getProject());
                this.filter.setFileResolver(this);
                this.filter.setFilterParameters(this.filterParameters);
                this.filter.init();
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Applying filter: " + this.filterType));
            }
            reader = this.filter.filter(reader, file.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerConfigurationException("Cannot process filter: " + this.filterType, e);
        }
        return reader;
    }

    public Source resolveAsSource(String filePath) throws TransformerConfigurationException {
        File file = this.resolve(filePath);
        return this.createSource(file);
    }
}

