/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class FileCache {
    private final Log log;
    private final File rebaseTo;
    private final File storeAt;
    private final String encoding;

    public FileCache(Log log, File rebaseTo, File storeAt, String encoding) {
        this.log = log;
        this.rebaseTo = rebaseTo;
        this.storeAt = storeAt;
        this.encoding = encoding;
    }

    public void store(Reader contentReader, File sourceFile) {
        try {
            File stored = this.getStored(sourceFile);
            if (null != stored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Storing content in file cache at " + stored));
                }
                stored.getParentFile().mkdirs();
                String content = IOUtil.toString((Reader)contentReader);
                FileUtils.fileWrite((String)stored.getPath(), (String)this.encoding, (String)content);
                contentReader.reset();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("File cannot be rebased, content not stored " + sourceFile));
            }
        }
        catch (IOException ioe) {
            this.log.error((CharSequence)("Cannot store content for file " + sourceFile), (Throwable)ioe);
        }
    }

    public Reader retrieve(File sourceFile) {
        try {
            File stored = this.getStored(sourceFile);
            if (null != stored && stored.exists()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Retrieving content in file cache at " + stored));
                }
                return new InputStreamReader((InputStream)new FileInputStream(stored), this.encoding);
            }
        }
        catch (IOException ioe) {
            this.log.error((CharSequence)("Cannot retrieve content for file " + sourceFile), (Throwable)ioe);
        }
        return null;
    }

    private File getStored(File sourceFile) throws IOException {
        String rebase = this.rebaseTo.getCanonicalPath();
        String filePath = sourceFile.getCanonicalPath();
        if (filePath.startsWith(rebase)) {
            String relativeName = filePath.substring(rebase.length());
            File stored = new File(this.storeAt, relativeName);
            return stored;
        }
        return null;
    }
}

