/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.sf.xsltmp.util.FileResolver;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleLoader {
    private final String bundle;
    private final String bundleLanguage;
    private final String bundleCountry;
    private final String bundleVariant;
    private final String bundleEncoding;
    private final FileResolver fileResolver;
    private final Log log;
    private final Map<String, Object> resourceMap;
    private boolean loaded = false;

    public BundleLoader(String bundle, String bundleLanguage, String bundleCountry, String bundleVariant, String bundleEncoding, FileResolver fileResolver, Map<String, Object> resourceMap) {
        this.bundle = bundle;
        this.bundleLanguage = bundleLanguage;
        this.bundleCountry = bundleCountry;
        this.bundleVariant = bundleVariant;
        this.bundleEncoding = bundleEncoding;
        this.fileResolver = fileResolver;
        this.log = fileResolver.getLog();
        this.resourceMap = resourceMap;
    }

    public void loadBundle() {
        this.loadResourceMaps(new Locale(this.bundleLanguage, this.bundleCountry, this.bundleVariant));
        this.loadResourceMaps(Locale.getDefault());
        if (!this.loaded) {
            throw new IllegalArgumentException("Bundle cannot be loaded " + this.bundle);
        }
    }

    private void loadResourceMaps(Locale locale) {
        String language = locale.getLanguage().length() > 0 ? "_" + locale.getLanguage() : "";
        String country = locale.getCountry().length() > 0 ? "_" + locale.getCountry() : "";
        String variant = locale.getVariant().length() > 0 ? "_" + locale.getVariant() : "";
        this.processBundle(this.bundle + language + country + variant);
        this.processBundle(this.bundle + language + country);
        this.processBundle(this.bundle + language);
        this.processBundle(this.bundle);
    }

    private void processBundle(String bundleFile) {
        block3: {
            File propsFile = this.fileResolver.resolve(bundleFile + ".properties");
            try {
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(propsFile), this.bundleEncoding));
                this.copyNonExistingEntries(properties);
                this.loaded = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Loaded properties: " + propsFile));
                }
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((CharSequence)("Cannot load properties: " + propsFile));
            }
        }
    }

    private void copyNonExistingEntries(Properties properties) {
        for (String string : properties.keySet()) {
            if (this.resourceMap.containsKey(string)) continue;
            this.resourceMap.put(string, properties.get(string));
        }
    }
}

